/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.tenant.registry.runtime.local;

import com.sap.core.tenant.common.TenantAdministrationException;
import com.sap.core.tenant.common.TenantData;
import com.sap.core.tenant.registry.runtime.api.Registry;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RegistryImpl
implements Registry {
    private static final Logger LOGGER = Logger.getLogger(RegistryImpl.class);
    private static final String DEV_DEFAULT = "dev_default";
    private static final TenantData DEFAULT_TENANT_DATA = new TenantData("dev_defaultId", "This is development tenant", "Name: dev_default", "dev_default", "dev_default");
    private static final File SPACE_PROPERTIES_FILE = new File("space.properties");

    public TenantData getTenantData(String alias) throws TenantAdministrationException {
        return this.getTenantData(alias, null);
    }

    public TenantData getTenantData(String alias, String urlPrefix) throws TenantAdministrationException {
        return this.getDefaultTenant(alias);
    }

    public TenantData getDefaultTenant() throws TenantAdministrationException {
        return this.getDefaultTenant(null);
    }

    public TenantData getDefaultTenant(String account) throws TenantAdministrationException {
        if (this.isRunningOnCloudNode()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"The tenant registry runtime will run in cloud mode, which means TenantData always will be null.");
            }
            return null;
        }
        if (account == null) {
            return DEFAULT_TENANT_DATA;
        }
        TenantData data = new TenantData(String.valueOf(account) + "Id", "This is development tenant", "Name: " + account, account, account);
        return data;
    }

    public TenantData getTenantDataById(String tenantId) throws TenantAdministrationException {
        if (DEFAULT_TENANT_DATA.getId().equals(tenantId)) {
            return DEFAULT_TENANT_DATA;
        }
        throw new TenantAdministrationException("Non default tenants are not supported in local runtime.");
    }

    private boolean isRunningOnCloudNode() {
        try {
            return SPACE_PROPERTIES_FILE.exists();
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"The tenant registry runtime will run in local mode.", (Throwable)e);
            }
            return false;
        }
    }

    public List<TenantData> getSubscribedTenants() throws TenantAdministrationException {
        throw new TenantAdministrationException("Get subscribed tenants is not supported in local runtime.");
    }

    public Map<String, String> getAccountAttributes(String accountName) throws TenantAdministrationException {
        throw new TenantAdministrationException("Get account attributes is not supported in local runtime.");
    }

    public Map<String, String> getAccountAttributes(String accountName, String attributeName) throws TenantAdministrationException {
        throw new TenantAdministrationException("Get account attributes is not supported in local runtime.");
    }

    public String getAccountDisplayName(String tenantId) throws TenantAdministrationException {
        throw new TenantAdministrationException("Get account name is not supported in local runtime.");
    }
}

