/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.impl;

import com.sap.js.statistics.impl.jmx.Statistics;
import com.sap.js.statistics.impl.jmx.StatisticsMBean;
import com.sap.js.statistics.impl.providers.RequestTracingValveHandler;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class StatisticsLifecycleHandler {
    private static final Logger logger = Logger.getLogger(StatisticsLifecycleHandler.class);
    private static final String SYS_CONF_ENABLE_STATISTICS = "com.sap.cloud.runtime.statistics.enable_on_start";
    private final MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();

    public void start() {
        ObjectName statistics = this.registerMBean();
        boolean statisticsEnabled = Boolean.getBoolean(SYS_CONF_ENABLE_STATISTICS);
        if (statisticsEnabled && statistics != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Enabling statistics because of system property com.sap.cloud.runtime.statistics.enable_on_start=" + statisticsEnabled));
            }
            this.switchStatisticsOnOrOff(statistics, true);
        }
    }

    public void stop() {
        this.unregisterMBean();
        RequestTracingValveHandler.getInstance().provideStatisticsTracingHandler(null);
    }

    private ObjectName registerMBean() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Start registering statistics mbean: com.sap.js:name=Statistics,type=Statistics");
        }
        try {
            ObjectName statisticsName = this.getStatisticsMBeanName();
            if (this.mbeanServer.isRegistered(statisticsName)) {
                logger.warn((Object)"Statistcs MBean already registered");
            } else {
                this.mbeanServer.registerMBean(new StatisticsMBean(), statisticsName);
            }
            return statisticsName;
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)"Statistics MBean name is not correct", (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            logger.warn((Object)"Cannot register Statistics MBean: already registered", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            logger.error((Object)"Cannot register Statistics MBean", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            logger.error((Object)"Cannot register Statistics MBean", (Throwable)e);
        }
        return null;
    }

    private void unregisterMBean() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Start unregistering statistics mbean: com.sap.js:name=Statistics,type=Statistics");
        }
        try {
            ObjectName statisticsName = this.getStatisticsMBeanName();
            if (this.mbeanServer.isRegistered(statisticsName)) {
                this.switchStatisticsOnOrOff(statisticsName, false);
                this.mbeanServer.unregisterMBean(statisticsName);
            } else {
                logger.warn((Object)"Cannot unregister Statistics MBean because it is not registered");
            }
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)"Statistics MBean name is not correct", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            logger.warn((Object)"Failed to unregister Statistics MBean", (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            logger.warn((Object)"Failed to unregister Statistics MBean", (Throwable)e);
        }
    }

    private ObjectName getStatisticsMBeanName() throws MalformedObjectNameException {
        return new ObjectName("com.sap.js:name=Statistics,type=Statistics");
    }

    private void switchStatisticsOnOrOff(ObjectName statisticsName, boolean on) {
        Statistics statisticsMbean = JMX.newMBeanProxy(this.mbeanServer, statisticsName, Statistics.class, true);
        statisticsMbean.doSwitch(on);
    }
}

