/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.impl;

import com.sap.js.statistics.api.writer.DSRAdmin;
import com.sap.js.statistics.impl.providers.RequestTracingValveHandler;
import com.sap.js.statistics.impl.providers.StatisticsConsumerProvider;
import com.sap.js.statistics.impl.providers.StatisticsProviderService;
import com.sap.js.statistics.impl.providers.StatisticsTracingHandler;
import com.sap.js.statistics.impl.threading.NamingThreadFactory;
import com.sap.js.statistics.impl.threading.StatisticsRejectionHandler;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatisticsManager {
    private static final Logger logger = Logger.getLogger(StatisticsManager.class.getName());
    private static final String CONFIG_HOME = "server.config.home";
    private static final String CONFIG_STATISTICS_BACKLOG_QUEUE_SIZE = "com.sap.js.statistics.queue_size";
    private static final String CONFIG_STATISTICS_WORKER_POOL_SIZE = "com.sap.js.statistics.pool_size";
    private static final String CONFIG_STATISTICS_REJECTION_LOGGING_FREQ = "com.sap.js.statistics.rejection_logging_freq";
    private static final String THREAD_PREFIX = "DSR Statistics Consumer Thread";
    private static final long DEFAULT_KEEP_ALIVE_TIME_MILLIS = 0L;
    private static final int DEFAULT_STATISTICS_BACKLOG_QUEUE_SIZE = 1024;
    private static final int DEFAULT_LOGGING_FREQUENCY = 1;
    private ExecutorService statisticsConsumersExecutor;
    private boolean isEnabled = false;

    public synchronized void enableMeasurement() throws IOException {
        if (this.isEnabled()) {
            return;
        }
        String currentDir = String.valueOf(new File(System.getProperty(CONFIG_HOME, ".")).getCanonicalPath()) + File.separator + "stats";
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Statistics dir: " + currentDir);
        }
        DSRAdmin.init((String)currentDir, (String)"localhost_ljs_001");
        this.statisticsConsumersExecutor = this.createStatisticsConsumerExecutor();
        StatisticsTracingHandler statisticsTracingHandler = StatisticsTracingHandler.getInstance();
        statisticsTracingHandler.setStatisticsProviders(StatisticsProviderService.getStatisticsProviders());
        statisticsTracingHandler.setStatisticsProviderExternalRecords(StatisticsProviderService.getStatisticsProviderExternalRecords());
        statisticsTracingHandler.setStatisticsConsumers(StatisticsConsumerProvider.getStatisticsConsumers());
        statisticsTracingHandler.setStatisticsConsumerWorkerPool(this.statisticsConsumersExecutor);
        RequestTracingValveHandler.getInstance().provideStatisticsTracingHandler(statisticsTracingHandler);
        this.isEnabled = true;
    }

    private ExecutorService createStatisticsConsumerExecutor() {
        int poolSize = this.computePoolSize();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "ThreadPool size: " + poolSize);
        }
        int queueSize = this.computeQueueSize();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Backlog queue size: " + queueSize);
        }
        int rejectionLoggingFrequency = StatisticsManager.computeRejectionLoggingFrequency();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Rejection logging frequency: " + rejectionLoggingFrequency);
        }
        StatisticsRejectionHandler.LoggingStrategy loggingStrategy = this.selectLoggingStrategy(rejectionLoggingFrequency);
        StatisticsRejectionHandler rejectionHandler = new StatisticsRejectionHandler(loggingStrategy);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Logging strategy: " + loggingStrategy);
        }
        NamingThreadFactory threadFactory = new NamingThreadFactory(THREAD_PREFIX);
        ArrayBlockingQueue<Runnable> taskQueue = new ArrayBlockingQueue<Runnable>(queueSize);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, taskQueue, threadFactory, rejectionHandler);
        return Executors.unconfigurableExecutorService(threadPoolExecutor);
    }

    private int computePoolSize() {
        int poolSize;
        Integer externalConfigPoolSize = Integer.getInteger(CONFIG_STATISTICS_WORKER_POOL_SIZE);
        if (externalConfigPoolSize != null && externalConfigPoolSize > 0) {
            poolSize = externalConfigPoolSize;
        } else {
            Runtime runtime = Runtime.getRuntime();
            poolSize = runtime.availableProcessors();
        }
        return poolSize;
    }

    private int computeQueueSize() {
        Integer externalConfigQueueSize = Integer.getInteger(CONFIG_STATISTICS_BACKLOG_QUEUE_SIZE);
        int queueSize = externalConfigQueueSize != null && externalConfigQueueSize > 0 ? externalConfigQueueSize : 1024;
        return queueSize;
    }

    private static int computeRejectionLoggingFrequency() {
        Integer externalLoggingFrequency = Integer.getInteger(CONFIG_STATISTICS_REJECTION_LOGGING_FREQ);
        if (externalLoggingFrequency != null) {
            if (externalLoggingFrequency >= 1) {
                return externalLoggingFrequency;
            }
            return 0;
        }
        return 1;
    }

    private StatisticsRejectionHandler.LoggingStrategy selectLoggingStrategy(int rejectionLoggingFrequency) {
        if (rejectionLoggingFrequency <= 0) {
            return new StatisticsRejectionHandler.NoOpLoggingStrategy();
        }
        if (rejectionLoggingFrequency == 1) {
            return new StatisticsRejectionHandler.LogEverythingStrategy();
        }
        return new StatisticsRejectionHandler.PartialLoggingStrategy(rejectionLoggingFrequency);
    }

    public synchronized void disableMeasurement() {
        if (!this.isEnabled()) {
            return;
        }
        RequestTracingValveHandler.getInstance().provideStatisticsTracingHandler(null);
        this.isEnabled = false;
        this.statisticsConsumersExecutor.shutdown();
    }

    public synchronized boolean isEnabled() {
        return this.isEnabled;
    }
}

