/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.impl.consumer;

import com.sap.js.statistics.api.DSRIRecord;
import com.sap.js.statistics.api.StatisticsConsumer;
import com.sap.js.statistics.api.writer.DSRAction;
import com.sap.js.statistics.api.writer.DSRRecord;
import com.sap.js.statistics.impl.trigger.DsrActionTrigger;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DsrActionConsumer
implements StatisticsConsumer {
    private static final Logger logger = Logger.getLogger(DsrActionConsumer.class.getName());
    private final boolean disabled = Boolean.getBoolean(String.valueOf(DsrActionTrigger.class.getName()) + ".disabled");

    public DsrActionConsumer() {
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "The DsrActionConsumer is " + (this.disabled ? "disabled" : "enabled"));
        }
    }

    public void requestFinished(DSRIRecord record) {
        if (this.disabled) {
            return;
        }
        if (!(record instanceof DSRRecord)) {
            logger.log(Level.SEVERE, "Expected instance of " + DSRRecord.class.getName() + " instead of " + (record == null ? "null" : record.getClass().getName()));
            return;
        }
        DSRRecord dsrRecord = (DSRRecord)record;
        DSRAction action = new DSRAction();
        action.setDSRRecord(dsrRecord);
        action.write();
    }
}

