/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.impl.jmx;

import com.sap.js.statistics.impl.jmx.DsrExternalRecordCompositeData;
import java.io.Serializable;
import javax.management.openmbean.CompositeData;

public class DsrExternalRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long callTime;
    private final long receivedBytes;
    private final long sentBytes;
    private final String destination;
    private final String addInfo;
    private final String type;
    private final String systemId;
    private final String connectionId;
    private final int connectionCounter;

    public DsrExternalRecord(long callTime, long receivedBytes, long sentBytes, String destination, String addInfo, String type, String systemId, String connectionId, int connectionCounter) {
        this.callTime = callTime;
        this.receivedBytes = receivedBytes;
        this.sentBytes = sentBytes;
        this.destination = destination;
        this.addInfo = addInfo;
        this.type = type;
        this.systemId = systemId;
        this.connectionId = connectionId;
        this.connectionCounter = connectionCounter;
    }

    private DsrExternalRecord(CompositeData cd) {
        DsrExternalRecordCompositeData.validateCompositeData(cd);
        this.callTime = DsrExternalRecordCompositeData.getCallTime(cd);
        this.receivedBytes = DsrExternalRecordCompositeData.getReceivedBytes(cd);
        this.sentBytes = DsrExternalRecordCompositeData.getSentBytes(cd);
        this.destination = DsrExternalRecordCompositeData.getDestination(cd);
        this.addInfo = DsrExternalRecordCompositeData.getAddInfo(cd);
        this.type = DsrExternalRecordCompositeData.getType(cd);
        this.systemId = DsrExternalRecordCompositeData.getSystemId(cd);
        this.connectionId = DsrExternalRecordCompositeData.getConnectionId(cd);
        this.connectionCounter = DsrExternalRecordCompositeData.getConnectionCounter(cd);
    }

    public static DsrExternalRecord from(CompositeData cd) {
        if (cd == null) {
            return null;
        }
        if (cd instanceof DsrExternalRecordCompositeData) {
            return ((DsrExternalRecordCompositeData)cd).getDsrExternalRecord();
        }
        return new DsrExternalRecord(cd);
    }

    public long getCallTime() {
        return this.callTime;
    }

    public long getReceivedBytes() {
        return this.receivedBytes;
    }

    public long getSentBytes() {
        return this.sentBytes;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getAddInfo() {
        return this.addInfo;
    }

    public String getType() {
        return this.type;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public int getConnectionCounter() {
        return this.connectionCounter;
    }
}

