/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.impl.jmx;

import com.sap.js.statistics.impl.jmx.DsrPassportApplVarPart;
import com.sap.js.statistics.impl.jmx.DsrPassportCompositeData;
import java.io.Serializable;
import java.util.Arrays;
import javax.management.openmbean.CompositeData;

public class DsrPassport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int traceFlag;
    private int serviceType;
    private int actionType;
    private String action;
    private String userId;
    private String transId;
    private String client;
    private String connectionId;
    private String rootContextId;
    private int connectionCounter;
    private byte[] connectionIdByte;
    private int systemType;
    private byte[] rootContextIdByte;
    private byte[] netPassport;
    private DsrPassportApplVarPart[] varItems;
    private int varItemsLength;

    public DsrPassport(int traceFlag, int serviceType, int actionType, String action, String userId, String transId, String client, String connectionId, String rootContextId, int connectionCounter, byte[] connectionIdByte, int systemType, byte[] rootContextIdByte, DsrPassportApplVarPart[] varItems, int varItemsLength, byte[] netPassport) {
        this.traceFlag = traceFlag;
        this.serviceType = serviceType;
        this.actionType = actionType;
        this.action = action;
        this.userId = userId;
        this.transId = transId;
        this.client = client;
        this.connectionId = connectionId;
        this.rootContextId = rootContextId;
        this.connectionCounter = connectionCounter;
        this.connectionIdByte = connectionIdByte;
        this.systemType = systemType;
        this.rootContextIdByte = rootContextIdByte;
        this.varItems = varItems;
        this.varItemsLength = varItemsLength;
        this.netPassport = netPassport;
    }

    private DsrPassport(CompositeData cd) {
        DsrPassportCompositeData.validateCompositeData(cd);
        this.traceFlag = DsrPassportCompositeData.getTraceFlag(cd);
        this.serviceType = DsrPassportCompositeData.getServiceType(cd);
        this.actionType = DsrPassportCompositeData.getActionType(cd);
        this.action = DsrPassportCompositeData.getAction(cd);
        this.userId = DsrPassportCompositeData.getUserId(cd);
        this.transId = DsrPassportCompositeData.getTransId(cd);
        this.client = DsrPassportCompositeData.getClient(cd);
        this.connectionId = DsrPassportCompositeData.getConnectionId(cd);
        this.rootContextId = DsrPassportCompositeData.getRootContextId(cd);
        this.connectionCounter = DsrPassportCompositeData.getConnectionCounter(cd);
        this.connectionIdByte = DsrPassportCompositeData.getConnectionIdByte(cd);
        this.systemType = DsrPassportCompositeData.getSystemType(cd);
        this.rootContextIdByte = DsrPassportCompositeData.getRootContextIdByte(cd);
        this.netPassport = DsrPassportCompositeData.getNetPassport(cd);
        this.varItems = DsrPassportCompositeData.getVarItems(cd);
        this.varItemsLength = DsrPassportCompositeData.getVarItemsLength(cd);
    }

    public static DsrPassport from(CompositeData cd) {
        if (cd == null) {
            return null;
        }
        if (cd instanceof DsrPassportCompositeData) {
            return ((DsrPassportCompositeData)cd).getPassport();
        }
        return new DsrPassport(cd);
    }

    public int getTraceFlag() {
        return this.traceFlag;
    }

    public int getServiceType() {
        return this.serviceType;
    }

    public int getActionType() {
        return this.actionType;
    }

    public String getAction() {
        return this.action;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getTransId() {
        return this.transId;
    }

    public String getClient() {
        return this.client;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getRootContextId() {
        return this.rootContextId;
    }

    public int getConnectionCounter() {
        return this.connectionCounter;
    }

    public byte[] getConnectionIdByte() {
        return Arrays.copyOf(this.connectionIdByte, this.connectionIdByte.length);
    }

    public int getSystemType() {
        return this.systemType;
    }

    public byte[] getRootContextIdByte() {
        return Arrays.copyOf(this.rootContextIdByte, this.rootContextIdByte.length);
    }

    public byte[] getNetPassport() {
        return Arrays.copyOf(this.netPassport, this.netPassport.length);
    }

    public DsrPassportApplVarPart[] getVarItems() {
        return Arrays.copyOf(this.varItems, this.varItems.length);
    }

    public int getVarItemsLength() {
        return this.varItemsLength;
    }
}

