/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.impl.jmx;

import com.sap.js.statistics.impl.jmx.DsrPassport;
import com.sap.js.statistics.impl.jmx.DsrPassportApplVarPart;
import com.sap.js.statistics.impl.jmx.DsrPassportApplVarPartCompositeData;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularType;

public class DsrPassportCompositeData
implements CompositeData,
Serializable {
    private static final long serialVersionUID = 1L;
    private final DsrPassport passport;
    private CompositeData compositeData;
    private static final String TRACE_FLAG = "traceFlag";
    private static final String SERVICE_TYPE = "serviceType";
    private static final String ACTION_TYPE = "actionType";
    private static final String ACTION = "action";
    private static final String USER_ID = "userId";
    private static final String TRANS_ID = "transId";
    private static final String CLIENT = "client";
    private static final String CONNECTION_ID = "connectionId";
    private static final String ROOT_CONTEXT_ID = "rootContextId";
    private static final String CONNECTION_COUNTER = "connectionCounter";
    private static final String CONNECTION_ID_BYTE = "connectionIdByte";
    private static final String SYSTEM_TYPE = "systemType";
    private static final String ROOT_CONTEXT_ID_BYTE = "rootContextIdByte";
    private static final String NET_PASSPORT = "netPassport";
    private static final String VAR_ITEMS = "varItems";
    private static final String VAR_ITEMS_LENGTH = "varItemsLength";
    private static final String[] dsrPassportItemNames = new String[]{"traceFlag", "serviceType", "actionType", "action", "userId", "transId", "client", "connectionId", "rootContextId", "connectionCounter", "connectionIdByte", "systemType", "rootContextIdByte", "netPassport", "varItems", "varItemsLength"};
    static CompositeType dsrPassportCompositeType = null;

    static {
        try {
            dsrPassportCompositeType = new CompositeType(DsrPassport.class.getName(), "DsrPassport", dsrPassportItemNames, dsrPassportItemNames, new OpenType[]{SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, ArrayType.getPrimitiveArrayType(byte[].class), SimpleType.INTEGER, ArrayType.getPrimitiveArrayType(byte[].class), ArrayType.getPrimitiveArrayType(byte[].class), ArrayType.getArrayType(DsrPassportApplVarPartCompositeData.dsrPassportApplVarPartCompositeType), SimpleType.INTEGER});
        }
        catch (Exception exception) {
            dsrPassportCompositeType = null;
        }
    }

    private DsrPassportCompositeData(DsrPassport passport) {
        this.passport = passport;
    }

    @Override
    public CompositeType getCompositeType() {
        return this.compositeData().getCompositeType();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.compositeData().containsValue(value);
    }

    public Collection values() {
        return this.compositeData().values();
    }

    @Override
    public String toString() {
        return this.compositeData().toString();
    }

    protected CompositeData getCompositeData() {
        if (this.passport == null) {
            return null;
        }
        ArrayList<CompositeData> varPartItemsList = new ArrayList<CompositeData>();
        DsrPassportApplVarPart[] variablePartItems = this.passport.getVarItems();
        if (variablePartItems != null) {
            int i = 0;
            while (i < variablePartItems.length) {
                DsrPassportApplVarPart dsrPassportApplVarPart = variablePartItems[i];
                varPartItemsList.add(DsrPassportApplVarPartCompositeData.toCompositeData(dsrPassportApplVarPart));
                ++i;
            }
        }
        Object[] dsrPassportItemValues = new Object[]{new Integer(this.passport.getTraceFlag()), new Integer(this.passport.getSystemType()), new Integer(this.passport.getActionType()), new String(this.passport.getAction()), new String(this.passport.getUserId()), new String(this.passport.getTransId()), new String(this.passport.getClient()), new String(this.passport.getConnectionId()), new String(this.passport.getRootContextId()), new Integer(this.passport.getConnectionCounter()), this.passport.getConnectionIdByte(), new Integer(this.passport.getSystemType()), this.passport.getRootContextIdByte(), this.passport.getNetPassport(), varPartItemsList.toArray(new CompositeData[varPartItemsList.size()]), varPartItemsList.size()};
        try {
            return new CompositeDataSupport(dsrPassportCompositeType, dsrPassportItemNames, dsrPassportItemValues);
        }
        catch (OpenDataException openDataException) {
            return null;
        }
    }

    private synchronized CompositeData compositeData() {
        if (this.compositeData != null) {
            return this.compositeData;
        }
        this.compositeData = this.getCompositeData();
        return this.compositeData;
    }

    public DsrPassport getPassport() {
        return this.passport;
    }

    static CompositeType getDsrPassportCompositeType() {
        return dsrPassportCompositeType;
    }

    public static CompositeData toCompositeData(DsrPassport p) {
        DsrPassportCompositeData drcd = new DsrPassportCompositeData(p);
        return drcd.getCompositeData();
    }

    public static void validateCompositeData(CompositeData cd) {
        if (cd == null) {
            throw new IllegalArgumentException("Null CompositeData");
        }
        if (!DsrPassportCompositeData.isTypeMatched(dsrPassportCompositeType, cd.getCompositeType())) {
            throw new IllegalArgumentException("Unexpected composite type for DsrPassport: " + cd.getCompositeType());
        }
    }

    public static int getTraceFlag(CompositeData cd) {
        return DsrPassportCompositeData.getInt(cd, TRACE_FLAG);
    }

    public static int getServiceType(CompositeData cd) {
        return DsrPassportCompositeData.getInt(cd, SERVICE_TYPE);
    }

    public static int getActionType(CompositeData cd) {
        return DsrPassportCompositeData.getInt(cd, ACTION_TYPE);
    }

    public static String getAction(CompositeData cd) {
        return DsrPassportCompositeData.getString(cd, ACTION);
    }

    public static String getUserId(CompositeData cd) {
        return DsrPassportCompositeData.getString(cd, USER_ID);
    }

    public static String getTransId(CompositeData cd) {
        return DsrPassportCompositeData.getString(cd, TRANS_ID);
    }

    public static String getClient(CompositeData cd) {
        return DsrPassportCompositeData.getString(cd, CLIENT);
    }

    public static String getConnectionId(CompositeData cd) {
        return DsrPassportCompositeData.getString(cd, CONNECTION_ID);
    }

    public static String getRootContextId(CompositeData cd) {
        return DsrPassportCompositeData.getString(cd, ROOT_CONTEXT_ID);
    }

    public static int getConnectionCounter(CompositeData cd) {
        return DsrPassportCompositeData.getInt(cd, CONNECTION_COUNTER);
    }

    public static byte[] getConnectionIdByte(CompositeData cd) {
        return DsrPassportCompositeData.getByteArray(cd, CONNECTION_ID_BYTE);
    }

    public static int getSystemType(CompositeData cd) {
        return DsrPassportCompositeData.getInt(cd, SYSTEM_TYPE);
    }

    public static byte[] getRootContextIdByte(CompositeData cd) {
        return DsrPassportCompositeData.getByteArray(cd, ROOT_CONTEXT_ID_BYTE);
    }

    public static byte[] getNetPassport(CompositeData cd) {
        return DsrPassportCompositeData.getByteArray(cd, NET_PASSPORT);
    }

    public static DsrPassportApplVarPart[] getVarItems(CompositeData cd) {
        return DsrPassportCompositeData.getDsrPassportApplVarPartArray(cd, VAR_ITEMS);
    }

    public static int getVarItemsLength(CompositeData cd) {
        return DsrPassportCompositeData.getInt(cd, VAR_ITEMS_LENGTH);
    }

    private static String getString(CompositeData cd, String itemName) {
        if (cd == null) {
            throw new IllegalArgumentException("Null CompositeData");
        }
        return (String)cd.get(itemName);
    }

    private static int getInt(CompositeData cd, String itemName) {
        if (cd == null) {
            throw new IllegalArgumentException("Null CompositeData");
        }
        return (Integer)cd.get(itemName);
    }

    private static byte[] getByteArray(CompositeData cd, String itemName) {
        if (cd == null) {
            throw new IllegalArgumentException("Null CompositeData");
        }
        return (byte[])cd.get(itemName);
    }

    private static DsrPassportApplVarPart[] getDsrPassportApplVarPartArray(CompositeData cd, String sysVarItems) {
        if (cd == null) {
            throw new IllegalArgumentException("Null CompositeData");
        }
        CompositeData[] varItemsCD = (CompositeData[])cd.get(sysVarItems);
        ArrayList<DsrPassportApplVarPart> result = new ArrayList<DsrPassportApplVarPart>();
        if (varItemsCD != null) {
            CompositeData[] compositeDataArray = varItemsCD;
            int n = varItemsCD.length;
            int n2 = 0;
            while (n2 < n) {
                CompositeData data = compositeDataArray[n2];
                result.add(DsrPassportApplVarPart.from(data));
                ++n2;
            }
        }
        return result.toArray(new DsrPassportApplVarPart[result.size()]);
    }

    private static boolean isTypeMatched(CompositeType type1, CompositeType type2) {
        if (type1 == type2) {
            return true;
        }
        Set<String> allItems = type1.keySet();
        if (!type2.keySet().containsAll(allItems)) {
            return false;
        }
        for (String item : allItems) {
            OpenType<?> ot1 = type1.getType(item);
            OpenType<?> ot2 = type2.getType(item);
            if (ot1 instanceof CompositeType) {
                if (!(ot2 instanceof CompositeType)) {
                    return false;
                }
                if (DsrPassportCompositeData.isTypeMatched((CompositeType)ot1, (CompositeType)ot2)) continue;
                return false;
            }
            if (ot1 instanceof TabularType) {
                if (!(ot2 instanceof TabularType)) {
                    return false;
                }
                if (DsrPassportCompositeData.isTypeMatched((TabularType)ot1, (TabularType)ot2)) continue;
                return false;
            }
            if (ot1.equals(ot2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isTypeMatched(TabularType type1, TabularType type2) {
        List<String> list2;
        if (type1 == type2) {
            return true;
        }
        List<String> list1 = type1.getIndexNames();
        if (!list1.equals(list2 = type2.getIndexNames())) {
            return false;
        }
        return DsrPassportCompositeData.isTypeMatched(type1.getRowType(), type2.getRowType());
    }

    @Override
    public Object get(String key) {
        return this.compositeData().get(key);
    }

    @Override
    public Object[] getAll(String[] keys) {
        return this.compositeData().getAll(keys);
    }

    @Override
    public boolean containsKey(String key) {
        return this.compositeData().containsKey(key);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return this.compositeData();
    }
}

