/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.impl.jmx;

import com.sap.js.statistics.impl.jmx.DsrExternalRecord;
import com.sap.js.statistics.impl.jmx.DsrPassport;
import com.sap.js.statistics.impl.jmx.DsrRecordCompositeData;
import java.io.Serializable;
import java.util.Arrays;
import javax.management.openmbean.CompositeData;

public class DsrRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String transId;
    private final String action;
    private final String userId;
    private final String addInfo;
    private final long startTime;
    private final int serviceType;
    private final int actionType;
    private final long respTime;
    private final long cpuTime;
    private final long allocMem;
    private final long dbTime;
    private final long extTime;
    private final long receivedBytes;
    private final long sentBytes;
    private final int dbCalls;
    private final int externalCalls;
    private final long dbIO;
    private final int sessionSize;
    private final DsrExternalRecord[] externalRecords;
    private final DsrPassport passport;

    public DsrRecord(String transId, String action, String userId, String addInfo, long startTime, int serviceType, int actionType, long respTime, long cpuTime, long allocMem, long dbTime, long extTime, long receivedBytes, long sentBytes, int dbCalls, int externalCalls, long dbIO, int sessionSize, DsrExternalRecord[] externalRecords, DsrPassport passport) {
        this.transId = transId == null ? "" : transId;
        this.action = action == null ? "" : action;
        this.userId = userId == null ? "" : userId;
        this.addInfo = addInfo == null ? "" : addInfo;
        this.startTime = startTime;
        this.serviceType = serviceType;
        this.actionType = actionType;
        this.respTime = respTime;
        this.cpuTime = cpuTime;
        this.allocMem = allocMem;
        this.dbTime = dbTime;
        this.extTime = extTime;
        this.receivedBytes = receivedBytes;
        this.sentBytes = sentBytes;
        this.dbCalls = dbCalls;
        this.externalCalls = externalCalls;
        this.dbIO = dbIO;
        this.sessionSize = sessionSize;
        this.externalRecords = externalRecords;
        this.passport = passport;
    }

    private DsrRecord(CompositeData cd) {
        DsrRecordCompositeData.validateCompositeData(cd);
        this.transId = DsrRecordCompositeData.getTransId(cd);
        this.action = DsrRecordCompositeData.getAction(cd);
        this.userId = DsrRecordCompositeData.getUserId(cd);
        this.addInfo = DsrRecordCompositeData.getAddInfo(cd);
        this.startTime = DsrRecordCompositeData.getStartTime(cd);
        this.serviceType = DsrRecordCompositeData.getServiceType(cd);
        this.actionType = DsrRecordCompositeData.getActionType(cd);
        this.respTime = DsrRecordCompositeData.getRespTime(cd);
        this.cpuTime = DsrRecordCompositeData.getCpuTime(cd);
        this.allocMem = DsrRecordCompositeData.getAllocMem(cd);
        this.dbTime = DsrRecordCompositeData.getDbTime(cd);
        this.extTime = DsrRecordCompositeData.getExtTime(cd);
        this.receivedBytes = DsrRecordCompositeData.getReceivedBytes(cd);
        this.sentBytes = DsrRecordCompositeData.getSentBytes(cd);
        this.dbCalls = DsrRecordCompositeData.getDbCalls(cd);
        this.externalCalls = DsrRecordCompositeData.getExternalCalls(cd);
        this.dbIO = DsrRecordCompositeData.getDbIO(cd);
        this.sessionSize = DsrRecordCompositeData.getSessionSize(cd);
        this.externalRecords = DsrRecordCompositeData.getExternalRecords(cd);
        this.passport = DsrRecordCompositeData.getPassport(cd);
    }

    public static DsrRecord from(CompositeData cd) {
        if (cd == null) {
            return null;
        }
        if (cd instanceof DsrRecordCompositeData) {
            return ((DsrRecordCompositeData)cd).getDsrRecord();
        }
        return new DsrRecord(cd);
    }

    public DsrPassport getPassport() {
        return this.passport;
    }

    public String getTransId() {
        return this.transId;
    }

    public String getAction() {
        return this.action;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAddInfo() {
        return this.addInfo;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getServiceType() {
        return this.serviceType;
    }

    public int getActionType() {
        return this.actionType;
    }

    public long getRespTime() {
        return this.respTime;
    }

    public long getCpuTime() {
        return this.cpuTime;
    }

    public long getAllocMem() {
        return this.allocMem;
    }

    public long getDbTime() {
        return this.dbTime;
    }

    public long getExternalTime() {
        return this.extTime;
    }

    public long getReceivedBytes() {
        return this.receivedBytes;
    }

    public long getSentBytes() {
        return this.sentBytes;
    }

    public int getDbCalls() {
        return this.dbCalls;
    }

    public int getExternalCalls() {
        return this.externalCalls;
    }

    public long getDbIO() {
        return this.dbIO;
    }

    public int getSessionSize() {
        return this.sessionSize;
    }

    public DsrExternalRecord[] getExternalRecords() {
        return Arrays.copyOf(this.externalRecords, this.externalRecords.length);
    }
}

