/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.impl.jmx;

import com.sap.js.statistics.impl.jmx.DsrExternalRecord;
import com.sap.js.statistics.impl.jmx.DsrExternalRecordCompositeData;
import com.sap.js.statistics.impl.jmx.DsrPassport;
import com.sap.js.statistics.impl.jmx.DsrPassportCompositeData;
import com.sap.js.statistics.impl.jmx.DsrRecord;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularType;

public class DsrRecordCompositeData
implements CompositeData,
Serializable {
    private static final long serialVersionUID = 1L;
    private final DsrRecord record;
    private CompositeData compositeData;
    private static final String TRANS_ID = "transId";
    private static final String ACTION = "action";
    private static final String USER_ID = "userId";
    private static final String ADD_INFO = "addInfo";
    private static final String START_TIME = "startTime";
    private static final String SERVICE_TYPE = "serviceType";
    private static final String ACTION_TYPE = "actionType";
    private static final String RESP_TIME = "respTime";
    private static final String CPU_TIME = "cpuTime";
    private static final String ALLOC_MEM = "allocMem";
    private static final String DB_TIME = "dbTime";
    private static final String EXT_TIME = "extTime";
    private static final String RECEIVED_BYTES = "receivedBytes";
    private static final String SENT_BYTES = "sentBytes";
    private static final String DB_CALLS = "dbCalls";
    private static final String EXTERNAL_CALLS = "externalCalls";
    private static final String DB_IO = "dbIO";
    private static final String SESSION_SIZE = "sessionSize";
    private static final String EXTERNAL_RECORDS = "externalRecords";
    private static final String PASSPORT = "passport";
    private static final String[] dsrRecordItemNames = new String[]{"transId", "action", "userId", "addInfo", "startTime", "serviceType", "actionType", "respTime", "cpuTime", "allocMem", "dbTime", "extTime", "receivedBytes", "sentBytes", "dbCalls", "externalCalls", "dbIO", "sessionSize", "externalRecords", "passport"};
    private static CompositeType dsrRecordCompositeType = null;

    static {
        try {
            dsrRecordCompositeType = new CompositeType(DsrRecord.class.getName(), "DsrRecord", dsrRecordItemNames, dsrRecordItemNames, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.LONG, SimpleType.INTEGER, ArrayType.getArrayType(DsrExternalRecordCompositeData.dsrExternalRecordCompositeType), DsrPassportCompositeData.dsrPassportCompositeType});
        }
        catch (Exception exception) {
            dsrRecordCompositeType = null;
        }
    }

    private DsrRecordCompositeData(DsrRecord record) {
        this.record = record;
    }

    @Override
    public CompositeType getCompositeType() {
        return this.compositeData().getCompositeType();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.compositeData().containsValue(value);
    }

    public Collection values() {
        return this.compositeData().values();
    }

    @Override
    public String toString() {
        return this.compositeData().toString();
    }

    protected CompositeData getCompositeData() {
        ArrayList<CompositeData> result = new ArrayList<CompositeData>();
        DsrExternalRecord[] externalRecords = this.record.getExternalRecords();
        if (externalRecords != null) {
            DsrExternalRecord[] dsrExternalRecordArray = externalRecords;
            int n = externalRecords.length;
            int n2 = 0;
            while (n2 < n) {
                DsrExternalRecord externalRecord = dsrExternalRecordArray[n2];
                result.add(DsrExternalRecordCompositeData.toCompositeData(externalRecord));
                ++n2;
            }
        }
        DsrPassport passport = this.record.getPassport();
        Object[] dsrRecordItemValues = new Object[]{new String(this.record.getTransId()), new String(this.record.getAction()), new String(this.record.getUserId()), new String(this.record.getAddInfo()), new Long(this.record.getStartTime()), new Integer(this.record.getServiceType()), new Integer(this.record.getActionType()), new Long(this.record.getRespTime()), new Long(this.record.getCpuTime()), new Long(this.record.getAllocMem()), new Long(this.record.getDbTime()), new Long(this.record.getExternalTime()), new Long(this.record.getReceivedBytes()), new Long(this.record.getSentBytes()), new Integer(this.record.getDbCalls()), new Integer(this.record.getExternalCalls()), new Long(this.record.getDbIO()), new Integer(this.record.getSessionSize()), result.toArray(new CompositeData[result.size()]), DsrPassportCompositeData.toCompositeData(passport)};
        try {
            return new CompositeDataSupport(dsrRecordCompositeType, dsrRecordItemNames, dsrRecordItemValues);
        }
        catch (OpenDataException openDataException) {
            return null;
        }
    }

    private synchronized CompositeData compositeData() {
        if (this.compositeData != null) {
            return this.compositeData;
        }
        this.compositeData = this.getCompositeData();
        return this.compositeData;
    }

    public DsrRecord getDsrRecord() {
        return this.record;
    }

    static CompositeType getDsrRecordCompositeType() {
        return dsrRecordCompositeType;
    }

    public static CompositeData toCompositeData(DsrRecord r) {
        DsrRecordCompositeData drcd = new DsrRecordCompositeData(r);
        return drcd.getCompositeData();
    }

    public static void validateCompositeData(CompositeData cd) {
        if (cd == null) {
            throw new NullPointerException("Null CompositeData");
        }
        if (!DsrRecordCompositeData.isTypeMatched(dsrRecordCompositeType, cd.getCompositeType())) {
            throw new IllegalArgumentException("Unexpected composite type for DsrRecord");
        }
    }

    public static String getTransId(CompositeData cd) {
        return DsrRecordCompositeData.getString(cd, TRANS_ID);
    }

    public static String getAction(CompositeData cd) {
        return DsrRecordCompositeData.getString(cd, ACTION);
    }

    public static String getUserId(CompositeData cd) {
        return DsrRecordCompositeData.getString(cd, USER_ID);
    }

    public static String getAddInfo(CompositeData cd) {
        return DsrRecordCompositeData.getString(cd, ADD_INFO);
    }

    public static long getStartTime(CompositeData cd) {
        return DsrRecordCompositeData.getLong(cd, START_TIME);
    }

    public static int getServiceType(CompositeData cd) {
        return DsrRecordCompositeData.getInt(cd, SERVICE_TYPE);
    }

    public static int getActionType(CompositeData cd) {
        return DsrRecordCompositeData.getInt(cd, ACTION_TYPE);
    }

    public static long getRespTime(CompositeData cd) {
        return DsrRecordCompositeData.getLong(cd, RESP_TIME);
    }

    public static long getCpuTime(CompositeData cd) {
        return DsrRecordCompositeData.getLong(cd, CPU_TIME);
    }

    public static long getAllocMem(CompositeData cd) {
        return DsrRecordCompositeData.getLong(cd, ALLOC_MEM);
    }

    public static long getDbTime(CompositeData cd) {
        return DsrRecordCompositeData.getLong(cd, DB_TIME);
    }

    public static long getExtTime(CompositeData cd) {
        return DsrRecordCompositeData.getLong(cd, EXT_TIME);
    }

    public static long getReceivedBytes(CompositeData cd) {
        return DsrRecordCompositeData.getLong(cd, RECEIVED_BYTES);
    }

    public static long getSentBytes(CompositeData cd) {
        return DsrRecordCompositeData.getLong(cd, SENT_BYTES);
    }

    public static int getDbCalls(CompositeData cd) {
        return DsrRecordCompositeData.getInt(cd, DB_CALLS);
    }

    public static int getExternalCalls(CompositeData cd) {
        return DsrRecordCompositeData.getInt(cd, EXTERNAL_CALLS);
    }

    public static long getDbIO(CompositeData cd) {
        return DsrRecordCompositeData.getLong(cd, DB_IO);
    }

    public static int getSessionSize(CompositeData cd) {
        return DsrRecordCompositeData.getInt(cd, SESSION_SIZE);
    }

    public static DsrPassport getPassport(CompositeData cd) {
        return DsrRecordCompositeData.getDsrPassport(cd, PASSPORT);
    }

    private static DsrPassport getDsrPassport(CompositeData cd, String itemName) {
        if (cd == null) {
            throw new IllegalArgumentException("Null CompositeData");
        }
        return DsrPassport.from((CompositeData)cd.get(itemName));
    }

    private static String getString(CompositeData cd, String itemName) {
        if (cd == null) {
            throw new IllegalArgumentException("Null CompositeData");
        }
        return (String)cd.get(itemName);
    }

    private static long getLong(CompositeData cd, String itemName) {
        if (cd == null) {
            throw new IllegalArgumentException("Null CompositeData");
        }
        return (Long)cd.get(itemName);
    }

    private static int getInt(CompositeData cd, String itemName) {
        if (cd == null) {
            throw new IllegalArgumentException("Null CompositeData");
        }
        return (Integer)cd.get(itemName);
    }

    private static boolean isTypeMatched(CompositeType type1, CompositeType type2) {
        if (type1 == type2) {
            return true;
        }
        Set<String> allItems = type1.keySet();
        if (!type2.keySet().containsAll(allItems)) {
            return false;
        }
        for (String item : allItems) {
            OpenType<?> ot1 = type1.getType(item);
            OpenType<?> ot2 = type2.getType(item);
            if (ot1 instanceof CompositeType) {
                if (!(ot2 instanceof CompositeType)) {
                    return false;
                }
                if (DsrRecordCompositeData.isTypeMatched((CompositeType)ot1, (CompositeType)ot2)) continue;
                return false;
            }
            if (ot1 instanceof TabularType) {
                if (!(ot2 instanceof TabularType)) {
                    return false;
                }
                if (DsrRecordCompositeData.isTypeMatched((TabularType)ot1, (TabularType)ot2)) continue;
                return false;
            }
            if (ot1.equals(ot2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isTypeMatched(TabularType type1, TabularType type2) {
        List<String> list2;
        if (type1 == type2) {
            return true;
        }
        List<String> list1 = type1.getIndexNames();
        if (!list1.equals(list2 = type2.getIndexNames())) {
            return false;
        }
        return DsrRecordCompositeData.isTypeMatched(type1.getRowType(), type2.getRowType());
    }

    @Override
    public Object get(String key) {
        return this.compositeData().get(key);
    }

    @Override
    public Object[] getAll(String[] keys) {
        return this.compositeData().getAll(keys);
    }

    @Override
    public boolean containsKey(String key) {
        return this.compositeData().containsKey(key);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return this.compositeData();
    }

    public static DsrExternalRecord[] getExternalRecords(CompositeData cd) {
        return DsrRecordCompositeData.getDsrExternalRecords(cd, EXTERNAL_RECORDS);
    }

    private static DsrExternalRecord[] getDsrExternalRecords(CompositeData cd, String itemName) {
        if (cd == null) {
            throw new IllegalArgumentException("Null CompositeData");
        }
        CompositeData[] nestedCD = (CompositeData[])cd.get(itemName);
        ArrayList<DsrExternalRecord> result = new ArrayList<DsrExternalRecord>();
        if (nestedCD != null) {
            CompositeData[] compositeDataArray = nestedCD;
            int n = nestedCD.length;
            int n2 = 0;
            while (n2 < n) {
                CompositeData data = compositeDataArray[n2];
                result.add(DsrExternalRecord.from(data));
                ++n2;
            }
        }
        return result.toArray(new DsrExternalRecord[result.size()]);
    }
}

