/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.impl.jmx;

import com.sap.jdsr.passport.DSRPassportApplVarPart;
import com.sap.jdsr.writer.DsrIPassport;
import com.sap.js.statistics.api.DSRIExternalRecord;
import com.sap.js.statistics.api.DSRIRecord;
import com.sap.js.statistics.api.DsrDataReader;
import com.sap.js.statistics.api.reader.DsrReaderException;
import com.sap.js.statistics.api.writer.DSRAdmin;
import com.sap.js.statistics.impl.StatisticsManager;
import com.sap.js.statistics.impl.jmx.DsrExternalRecord;
import com.sap.js.statistics.impl.jmx.DsrPassport;
import com.sap.js.statistics.impl.jmx.DsrPassportApplVarPart;
import com.sap.js.statistics.impl.jmx.DsrRecord;
import com.sap.js.statistics.impl.jmx.DsrRecordCompositeData;
import com.sap.js.statistics.impl.jmx.Statistics;
import com.sap.js.statistics.impl.providers.trace.LoggingTraceFilterImpl;
import com.sap.js.statistics.impl.providers.trace.TraceService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class StatisticsMBean
extends StandardMBean
implements Statistics {
    private static final double PERCENTS = 100.0;
    private static final long MAX_USABLE_MEMORY = 65L;
    private static final Logger logger = Logger.getLogger(StatisticsMBean.class);
    private final StatisticsManager statisticsManager = new StatisticsManager();
    private boolean isEnabledTracing = false;

    public StatisticsMBean() throws NotCompliantMBeanException {
        super(Statistics.class);
    }

    @Override
    public synchronized boolean doSwitch(boolean toggle) {
        if (this.isSwitched() == toggle) {
            return true;
        }
        return toggle ? this.switchOn() : this.switchOff();
    }

    @Override
    public synchronized boolean flush() {
        return DSRAdmin.flush();
    }

    @Override
    public synchronized boolean syncFlush() {
        return DSRAdmin.syncFlush();
    }

    @Override
    public synchronized boolean clean() {
        return DSRAdmin.clean();
    }

    @Override
    public synchronized boolean isSwitched() {
        return this.statisticsManager.isEnabled();
    }

    @Override
    public synchronized boolean enableTracing(boolean toggle) {
        if (this.isEnabledTracing() == toggle) {
            return true;
        }
        return toggle ? this.toggleOnTracing() : this.toggleOffTracing();
    }

    @Override
    public synchronized boolean enableTracing(boolean toggle, String[] loggers, String[] levels) {
        return toggle ? this.toggleOnTracing(loggers, levels) : this.toggleOffTracing();
    }

    private boolean toggleOnTracing() {
        String[] loggers = new String[]{Logger.getRootLogger().getName()};
        String[] levels = new String[]{Level.ALL.toString()};
        return this.toggleOnTracing(loggers, levels);
    }

    private boolean toggleOnTracing(String[] loggers, String[] levels) {
        try {
            this.statisticsManager.enableMeasurement();
        }
        catch (IOException e) {
            logger.error((Object)"Problem occurred while enabling measurement.", (Throwable)e);
            return false;
        }
        TraceService.startSessionTrace(loggers, levels, new LoggingTraceFilterImpl());
        this.isEnabledTracing = true;
        return true;
    }

    private boolean toggleOffTracing() {
        TraceService.stopSessionTrace();
        this.isEnabledTracing = false;
        return true;
    }

    @Override
    public boolean isEnabledTracing() {
        return this.isEnabledTracing;
    }

    private boolean switchOn() {
        if (this.isSwitched()) {
            return true;
        }
        try {
            this.statisticsManager.enableMeasurement();
        }
        catch (IOException e) {
            logger.error((Object)"Problem occurred while enabling statistics measurements", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean switchOff() {
        if (!this.isSwitched()) {
            return true;
        }
        this.syncFlush();
        this.statisticsManager.disableMeasurement();
        return true;
    }

    @Override
    public CompositeData[] getRecords(long since, long to) {
        if (0L > since || since > to) {
            return new ArrayList(0).toArray(new CompositeData[0]);
        }
        return this.getRecordsInternal(since, to);
    }

    @Override
    public CompositeData[] getRecords(long since) {
        return this.getRecords(since, Long.MAX_VALUE);
    }

    @Override
    public CompositeData[] getAllRecords() {
        return this.getRecords(1L);
    }

    private CompositeData[] getRecordsInternal(long since, long to) {
        ArrayList<CompositeData> result = new ArrayList<CompositeData>();
        try {
            this.syncFlush();
            DsrDataReader reader = new DsrDataReader(DSRAdmin.getDsrRoot(), DSRAdmin.getComponent(), since, to, null, false);
            DSRIRecord record = reader.getNextRecord();
            while (record != null) {
                Object dsrPassportApplVarPart;
                int i;
                DsrIPassport passportRecord = record.getPassportRecord();
                DsrPassport dsrPassport = null;
                if (passportRecord != null) {
                    DSRPassportApplVarPart[] varItems = passportRecord.getVarItems();
                    DsrPassportApplVarPart[] varItemsToInject = new DsrPassportApplVarPart[varItems.length];
                    i = 0;
                    while (i < varItems.length) {
                        DSRPassportApplVarPart sourceDSRPassportApplVarPart = varItems[i];
                        varItemsToInject[i] = dsrPassportApplVarPart = new DsrPassportApplVarPart(sourceDSRPassportApplVarPart.getApplId(), sourceDSRPassportApplVarPart.getKey(), sourceDSRPassportApplVarPart.getType(), sourceDSRPassportApplVarPart.getLength(), sourceDSRPassportApplVarPart.getBytes(), sourceDSRPassportApplVarPart.getIntValue(), sourceDSRPassportApplVarPart.getStrValue(), sourceDSRPassportApplVarPart.getVarPartType());
                        ++i;
                    }
                    dsrPassport = new DsrPassport(passportRecord.getTraceFlag(), passportRecord.getService(), passportRecord.getActionType(), passportRecord.getAction(), passportRecord.getUserId(), passportRecord.getTransId(), passportRecord.getClientNumber(), passportRecord.getConnectionIdHex(), passportRecord.getRootContextIdHex(), passportRecord.getConnectionCounter(), passportRecord.getConnectionIdBytes(), passportRecord.getSystemType(), passportRecord.getRootContextIdBytes(), varItemsToInject, varItemsToInject.length, passportRecord.getNetPassport());
                }
                ArrayList<DsrExternalRecord> externalRecords = new ArrayList<DsrExternalRecord>();
                dsrPassportApplVarPart = record.getExternalRecords();
                int n = ((DSRIExternalRecord[])dsrPassportApplVarPart).length;
                i = 0;
                while (i < n) {
                    DSRIExternalRecord externalRecord = dsrPassportApplVarPart[i];
                    externalRecords.add(new DsrExternalRecord(externalRecord.getCallTime(), externalRecord.getReceivedBytes(), externalRecord.getSentBytes(), externalRecord.getDestination(), externalRecord.getAddInfo(), externalRecord.getTypeString(), externalRecord.getSystemId(), new String(externalRecord.getConnectionId(), "UTF-8"), externalRecord.getConnectionCounter()));
                    ++i;
                }
                DsrRecord currentRecord = new DsrRecord(record.getMainRecord().getTransId(), record.getMainRecord().getAction(), record.getMainRecord().getUserId(), record.getMainRecord().getAddInfo(), record.getMainRecord().getStartTime(), record.getMainRecord().getServiceType(), record.getMainRecord().getActionType(), record.getMainRecord().getRespTime(), record.getMainRecord().getCpuTime(), record.getMainRecord().getAllocMem(), record.getMainRecord().getDbTime(), record.getMainRecord().getExternalTime(), record.getMainRecord().getReceivedBytes(), record.getMainRecord().getSentBytes(), record.getMainRecord().getDbCalls(), record.getExternalRecords().length, record.getMainRecord().getDbIO(), record.getMainRecord().getSessionSize(), externalRecords.toArray(new DsrExternalRecord[externalRecords.size()]), dsrPassport);
                result.add(DsrRecordCompositeData.toCompositeData(currentRecord));
                long freeMemory = Runtime.getRuntime().freeMemory();
                long totalMemory = Runtime.getRuntime().totalMemory();
                double usage = (1.0 - (double)freeMemory / (double)totalMemory) * 100.0;
                long round = Math.round(usage);
                if (round >= 65L) {
                    if (logger.isEnabledFor(Priority.WARN)) {
                        logger.warn((Object)("Memmory usage is above 65% (" + round + "%). Stopping record reading at " + result.size() + " records!"));
                    }
                    record = null;
                    continue;
                }
                record = reader.getNextRecord();
            }
        }
        catch (DsrReaderException e) {
            logger.error((Object)"Problem occured while creating reader.", (Throwable)e);
            return new ArrayList(0).toArray(new CompositeData[0]);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Problem occured while creating reader.", (Throwable)e);
            return new ArrayList(0).toArray(new CompositeData[0]);
        }
        return result.toArray(new CompositeData[result.size()]);
    }
}

