/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.impl.providers;

import com.sap.jdsr.passport.DSRPassport;
import com.sap.js.statistics.api.providers.StatisticsProvider;
import com.sap.js.statistics.api.providers.StatisticsProviderExternalRecords;
import com.sap.js.statistics.impl.providers.StatisticsThreadContext;
import com.sap.js.statistics.impl.providers.StatisticsTracingHandler;
import java.util.Collection;
import org.apache.log4j.Logger;

public class RequestTracingValveHandler {
    private static final Logger logger = Logger.getLogger(RequestTracingValveHandler.class);
    private static RequestTracingValveHandler INSTANCE = new RequestTracingValveHandler();
    private static ThreadLocal<DSRPassport> currentPassport = new ThreadLocal();
    private StatisticsTracingHandler handler;

    private RequestTracingValveHandler() {
    }

    public static RequestTracingValveHandler getInstance() {
        return INSTANCE;
    }

    public void requestStarted(Collection<StatisticsProvider> additioinalProviders, Collection<StatisticsProviderExternalRecords> additionalProvidersExternalRecords) {
        if (this.handler != null) {
            this.handler.requestStarted(additioinalProviders, additionalProvidersExternalRecords);
        }
    }

    public void requestFinished(StatisticsThreadContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Incoming HTTP request (end method)");
        }
        if (this.handler != null) {
            this.handler.requestFinished(context);
        }
    }

    public void setCurrentPassport(DSRPassport passport) {
        currentPassport.set(passport);
    }

    public DSRPassport getCurrentPassport() {
        return currentPassport.get();
    }

    public void provideStatisticsTracingHandler(StatisticsTracingHandler h) {
        this.handler = h;
    }

    public boolean hasStatisticsTracingHandler() {
        return this.getStatisticsTracingHandler() != null;
    }

    public StatisticsTracingHandler getStatisticsTracingHandler() {
        return this.handler;
    }
}

