/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.impl.providers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.apache.felix.service.command.Descriptor;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class StatisticsCommandProvider {
    private static final int LENGTH_ACTION_FIELD = 70;
    private static final int LENGTH_RESPONSE_TIME_FIELD = 10;
    private static final int LENGTH_EXTERNAL_TIME_FIELD = 10;
    private static final int LENGTH_START_TIME_FIELD = 30;
    private static final int LENGTH_CPU_TIME_FIELD = 20;
    private static final int LENGTH_MEMORY_FIELD = 30;
    private static final int LENGTH_SENT_BYTES_FIELD = 30;
    private static final int LENGTH_RECEIVED_BYTES_FIELD = 30;
    private static final String TRACE_CONFIG_FILE = "trace.cfg";
    private static final String CONFIG_MASTER_FOLDER = "config_master";
    private static final String TRACE_FOLDER = "com.sap.js.session.trace";
    private static final String DASHES = "--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------";
    private static final String READ_DUMP_FILE_PREFIX = "stats_read_";
    private static final String READ_DUMP_FILE_SUFIX = ".txt";
    private static final String CONFIG_HOME = "server.config.home";
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();

    @Descriptor(value="read statistical records, including external record details")
    public void stats_read_details() {
        System.out.println("Read statistical records");
        try {
            if (!this.isSwitched()) {
                System.out.println("Statistics measurements are disabled");
                return;
            }
            CompositeData[] records = (CompositeData[])this.mBeanServer.getAttribute(new ObjectName("com.sap.js:name=Statistics,type=Statistics"), "AllRecords");
            int i = 0;
            while (i < records.length) {
                this.printRecDetails(records[i]);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Descriptor(value="displays statistical records\r\n   stats_read [out_dir] - if out_dir is specified, it dumps the statistics in file \"stats_read_<timestamp>.txt\" in out_dir and displays them\n\t")
    public void stats_read(String ... outDir) {
        BufferedWriter output;
        Writer writer;
        OutputStream os;
        block40: {
            block41: {
                System.out.println("Read statistical records");
                os = null;
                writer = null;
                output = null;
                if (this.isSwitched()) break block40;
                System.out.println("Statistics measurements are disabled");
                if (output == null) break block41;
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            if (os == null) return;
            try {
                os.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        try {
            try {
                File outputFile;
                File outputDir = outDir.length == 0 ? null : new File(outDir[0]);
                File file = outputFile = this.isValid(outputDir) ? new File(outputDir, READ_DUMP_FILE_PREFIX + System.currentTimeMillis() + READ_DUMP_FILE_SUFIX) : null;
                if (outputFile != null) {
                    os = new FileOutputStream(outputFile);
                    writer = new OutputStreamWriter(os, "UTF-8");
                    output = new BufferedWriter(writer);
                } else {
                    output = null;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(this.formatString("Action", 70));
                sb.append(this.formatString(" Start Time ", 30));
                sb.append(this.formatString("RespTime", 10));
                sb.append(this.formatString("CpuTime", 20));
                sb.append(this.formatString("Memory", 30));
                sb.append(this.formatString("ExtTime", 10));
                sb.append(this.formatString("SentBytesTime", 30));
                sb.append(this.formatString("RecBytesTime", 30));
                String sbStr = sb.toString();
                System.out.println(sbStr);
                System.out.println(DASHES);
                if (output != null) {
                    output.write(sbStr);
                    output.newLine();
                    output.write(DASHES);
                    output.newLine();
                }
                CompositeData[] records = (CompositeData[])this.mBeanServer.getAttribute(new ObjectName("com.sap.js:name=Statistics,type=Statistics"), "AllRecords");
                int i = 0;
                while (i < records.length) {
                    sb.setLength(0);
                    this.printRecTable(records[i], output, sb);
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                if (os == null) return;
                try {
                    os.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            if (os == null) throw throwable;
            try {
                os.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        if (os == null) return;
        try {
            os.close();
            return;
        }
        catch (IOException iOException) {}
    }

    private boolean isValid(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists() && !dir.mkdirs()) {
            System.out.println("Cannot create directory: " + dir);
            return false;
        }
        if (!dir.canWrite()) {
            System.out.println("Cannot write in directory: " + dir);
            return false;
        }
        return true;
    }

    private void printRecTable(CompositeData rec, BufferedWriter output, StringBuilder sb) throws IOException {
        Date startTimeDate = new Date((Long)rec.get("startTime"));
        sb.append(this.formatString("" + rec.get("action"), 70));
        sb.append(this.formatString(" " + DateFormat.getDateTimeInstance().format(startTimeDate) + " ", 30));
        sb.append(this.formatString("" + rec.get("respTime"), 10));
        sb.append(this.formatString("" + rec.get("cpuTime"), 20));
        sb.append(this.formatString("" + rec.get("allocMem"), 30));
        sb.append(this.formatString("" + rec.get("extTime"), 10));
        sb.append(this.formatString("" + rec.get("sentBytes"), 30));
        sb.append(this.formatString("" + rec.get("receivedBytes"), 30));
        String sbStr = sb.toString();
        System.out.println(sbStr);
        if (output != null) {
            output.write(sbStr);
            output.newLine();
        }
    }

    private void printRecDetails(CompositeData rec) {
        System.out.println("------------next statistical record----------------------");
        Date startTimeDate = new Date((Long)rec.get("startTime"));
        System.out.println("Start Time: " + DateFormat.getDateTimeInstance().format(startTimeDate));
        System.out.println("Action: " + rec.get("action"));
        System.out.println("Response Time: " + rec.get("respTime"));
        System.out.println("User: " + rec.get("userId"));
        System.out.println("DSR Transaction ID: " + rec.get("transId"));
        System.out.println("CPU Time: " + rec.get("cpuTime"));
        System.out.println("Allocated Memory: " + rec.get("allocMem"));
        System.out.println("External Time: " + rec.get("extTime"));
        System.out.println("External Calls: " + rec.get("externalCalls"));
        System.out.println("Received Bytes: " + rec.get("receivedBytes"));
        System.out.println("Sent Bytes: " + rec.get("sentBytes"));
        CompositeData[] extRecs = (CompositeData[])rec.get("externalRecords");
        if (extRecs != null) {
            int counter = 1;
            CompositeData[] compositeDataArray = extRecs;
            int n = extRecs.length;
            int n2 = 0;
            while (n2 < n) {
                CompositeData extRec = compositeDataArray[n2];
                this.printExtRecDetails(extRec, counter++);
                ++n2;
            }
        }
        System.out.println();
    }

    private void printExtRecDetails(CompositeData rec, int counter) {
        System.out.println("------------ statistical external record " + counter + " ----------------------");
        System.out.println("    Call Time: " + rec.get("callTime"));
        System.out.println("    Received Bytes: " + rec.get("receivedBytes"));
        System.out.println("    Sent Bytes: " + rec.get("sentBytes"));
        System.out.println("    Destination: " + rec.get("destination"));
        System.out.println("    Add Info: " + rec.get("addInfo"));
        System.out.println("    Type: " + rec.get("type"));
        System.out.println("    System ID: " + rec.get("systemId"));
        System.out.println("    Connection ID: " + rec.get("connectionId"));
        System.out.println("    Connection Counter: " + rec.get("connectionCounter"));
    }

    @Descriptor(value="flush internal buffers\n")
    public void stats_flush() {
        try {
            if (!this.isSwitched()) {
                System.out.println("Statistics measurements are disabled");
                return;
            }
            System.out.println("Flush statistic records");
            this.mBeanServer.invoke(new ObjectName("com.sap.js:name=Statistics,type=Statistics"), "flush", new Object[0], new String[0]);
            System.out.println("Flush done");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    @Descriptor(value="flush internal buffers synchronously")
    public void stats_sync_flush() {
        try {
            if (!this.isSwitched()) {
                System.out.println("Statistics measurements are disabled");
                return;
            }
            System.out.println("Flush statistic records");
            this.mBeanServer.invoke(new ObjectName("com.sap.js:name=Statistics,type=Statistics"), "syncFlush", new Object[0], new String[0]);
            System.out.println("Flush done");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    @Descriptor(value="enable collecting statistics")
    public void stats_enable() {
        System.out.println("Enable statistics records");
        try {
            this.mBeanServer.invoke(new ObjectName("com.sap.js:name=Statistics,type=Statistics"), "doSwitch", new Object[]{true}, new String[]{Boolean.TYPE.getName()});
            System.out.println("done.");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    @Descriptor(value="disable collecting statistics")
    public void stats_disable() {
        System.out.println("Disable statistics records");
        try {
            this.mBeanServer.invoke(new ObjectName("com.sap.js:name=Statistics,type=Statistics"), "doSwitch", new Object[]{false}, new String[]{Boolean.TYPE.getName()});
            System.out.println("done.");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    @Descriptor(value="delete all statistics records")
    public void stats_clean() {
        try {
            if (!this.isSwitched()) {
                System.out.println("Statistics measurements are disabled");
                return;
            }
            System.out.println("Clean all statistic records");
            this.mBeanServer.invoke(new ObjectName("com.sap.js:name=Statistics,type=Statistics"), "clean", new Object[0], new String[0]);
            System.out.println("Clean done");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    @Descriptor(value="check if collecting statistics is enabled")
    public void stats_is_enabled() {
        if (this.isSwitched()) {
            System.out.println("Statistics measurements are enabled");
            return;
        }
        System.out.println("Statistics measurements are disabled");
    }

    private boolean isSwitched() {
        try {
            return (Boolean)this.mBeanServer.getAttribute(new ObjectName("com.sap.js:name=Statistics,type=Statistics"), "Switched");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return false;
        }
    }

    @Descriptor(value="enable/disable trace\r\n   stats_trace on|off")
    public void stats_trace(@Descriptor(value="switch - on or off") String op) {
        if (op.equalsIgnoreCase("on")) {
            this.enableTrace();
        } else if (op.equalsIgnoreCase("off")) {
            this.disableTrace();
        } else {
            System.out.println("Please provide on or off");
        }
    }

    private void enableTrace() {
        String[] levels;
        String[] loggers;
        Properties properties;
        block20: {
            File f = new File(String.valueOf(System.getProperty(CONFIG_HOME, ".")) + File.separator + CONFIG_MASTER_FOLDER + File.separator + TRACE_FOLDER + File.separator + TRACE_CONFIG_FILE);
            if (!f.exists()) {
                System.out.println("Trace module: config file could not be found.");
                return;
            }
            FileInputStream fis = null;
            properties = new Properties();
            try {
                try {
                    fis = new FileInputStream(f);
                    properties.load(fis);
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        properties.remove("session.trace");
        if (!properties.isEmpty()) {
            loggers = new String[properties.size()];
            levels = new String[properties.size()];
            int index = 0;
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String key;
                loggers[index] = key = (String)e.nextElement();
                levels[index] = (String)properties.get(key);
                ++index;
            }
        } else {
            loggers = new String[1];
            levels = new String[1];
            loggers[0] = Logger.getRootLogger().getName();
            levels[0] = Level.ALL.toString();
        }
        try {
            this.mBeanServer.invoke(new ObjectName("com.sap.js:name=Statistics,type=Statistics"), "enableTracing", new Object[]{Boolean.TRUE, loggers, levels}, new String[]{Boolean.TYPE.getName(), String[].class.getName(), String[].class.getName()});
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void disableTrace() {
        try {
            this.mBeanServer.invoke(new ObjectName("com.sap.js:name=Statistics,type=Statistics"), "enableTracing", new Object[]{Boolean.FALSE}, new String[]{Boolean.TYPE.getName()});
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private String formatString(String input, int len) {
        StringBuilder res = new StringBuilder();
        if (input.length() < len) {
            res.append(input);
            int i = 0;
            while (i < len - input.length()) {
                res.append(" ");
                ++i;
            }
        } else {
            res.append("...").append(input.substring(input.length() - len + 3));
        }
        return res.toString();
    }
}

