/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.impl.providers;

import com.sap.js.statistics.api.providers.StatisticsProvider;
import com.sap.js.statistics.api.providers.StatisticsProviderExternalRecords;
import java.util.Collection;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public class StatisticsProviderService {
    private static final Logger LOG = Logger.getLogger(StatisticsProviderService.class);
    private static Collection<StatisticsProvider> statisticProviders = new CopyOnWriteArrayList<StatisticsProvider>();
    private static Collection<StatisticsProviderExternalRecords> statisticsProviderExternalRecords = new CopyOnWriteArrayList<StatisticsProviderExternalRecords>();
    private static ClassLoader implClassLoader = null;

    public static Collection<StatisticsProvider> getStatisticsProviders() {
        if (statisticProviders.isEmpty()) {
            ServiceLoader<StatisticsProvider> serviceLoader;
            if (implClassLoader != null) {
                serviceLoader = ServiceLoader.load(StatisticsProvider.class, implClassLoader);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Inside StatisticsServiceTracker.getStatisticsProviders() " + implClassLoader));
                }
            } else {
                serviceLoader = ServiceLoader.load(StatisticsProvider.class);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Inside StatisticsServiceTracker.getStatisticsProviders()");
                }
            }
            try {
                for (StatisticsProvider statsProvider : serviceLoader) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Inside StatisticsServiceTracker.getStatisticsProviders() " + statsProvider));
                    }
                    statisticProviders.add(statsProvider);
                }
            }
            catch (ServiceConfigurationError serviceConfigurationError) {}
            return statisticProviders;
        }
        return statisticProviders;
    }

    public static Collection<StatisticsProviderExternalRecords> getStatisticsProviderExternalRecords() {
        if (statisticsProviderExternalRecords.isEmpty()) {
            ServiceLoader<StatisticsProviderExternalRecords> serviceLoader;
            if (implClassLoader != null) {
                serviceLoader = ServiceLoader.load(StatisticsProviderExternalRecords.class, implClassLoader);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Inside StatisticsServiceTracker.getStatisticsProviderExternalRecords() " + implClassLoader));
                }
            } else {
                serviceLoader = ServiceLoader.load(StatisticsProviderExternalRecords.class);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Inside StatisticsServiceTracker.getStatisticsProviderExternalRecords()");
                }
            }
            try {
                for (StatisticsProviderExternalRecords statsProvider : serviceLoader) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Inside StatisticsServiceTracker.getStatisticsProviderExternalRecords() " + statsProvider));
                    }
                    statisticsProviderExternalRecords.add(statsProvider);
                }
            }
            catch (ServiceConfigurationError serviceConfigurationError) {}
            return statisticsProviderExternalRecords;
        }
        return statisticsProviderExternalRecords;
    }

    public synchronized void addStatisticsProvider(StatisticsProvider statsProvider) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Inside StatisticsServiceTracker.addService(StatisticsProvider statsProvider)");
        }
        statisticProviders.add(statsProvider);
    }

    public synchronized void removeStatisticsProvider(StatisticsProvider statsProvider) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Inside StatisticsServiceTracker.removeService(StatisticsProvider statsProvider)");
        }
        statisticProviders.remove(statsProvider);
    }

    public synchronized void addStatisticsProviderExternalRecords(StatisticsProviderExternalRecords statsProvider) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Inside StatisticsServiceTracker.addStatisticsProviderExternalRecords(StatisticsProviderExternalRecords statsProvider)");
        }
        statisticsProviderExternalRecords.add(statsProvider);
    }

    public synchronized void removeStatisticsProviderExternalRecords(StatisticsProviderExternalRecords statsProvider) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Inside StatisticsServiceTracker.removeStatisticsProviderExternalRecords(StatisticsProviderExternalRecords statsProvider)");
        }
        statisticsProviderExternalRecords.remove(statsProvider);
    }

    public static void setImplClassLoader(ClassLoader classLoader) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Inside StatisticsServiceTracker.setImplClassLoader(" + classLoader + ")"));
        }
        implClassLoader = classLoader;
    }
}

