/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.impl.providers;

import com.sap.jdsr.passport.DSRPassport;
import com.sap.js.statistics.api.DSRIRecord;
import com.sap.js.statistics.api.StatisticsConsumer;
import com.sap.js.statistics.api.providers.StatisticsProvider;
import com.sap.js.statistics.api.providers.StatisticsProviderExternalRecords;
import com.sap.js.statistics.api.writer.DSRExternalRecord;
import com.sap.js.statistics.api.writer.DSRMainRecord;
import com.sap.js.statistics.api.writer.DSRRecord;
import com.sap.js.statistics.impl.providers.StatisticsThreadContext;
import com.sap.js.statistics.impl.threading.StatisticsReportTask;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatisticsTracingHandler {
    private static final Logger logger = Logger.getLogger(StatisticsTracingHandler.class.getName());
    private static final StatisticsTracingHandler INSTANCE = new StatisticsTracingHandler();
    private Collection<StatisticsProvider> providers;
    private Collection<StatisticsProviderExternalRecords> providerExternalRecords;
    private Collection<StatisticsConsumer> statisticsConsumers;
    private ExecutorService statisticsConsumerWorkerPool;

    private StatisticsTracingHandler() {
    }

    public static StatisticsTracingHandler getInstance() {
        return INSTANCE;
    }

    public void setStatisticsProviders(Collection<StatisticsProvider> statisticsProviders) {
        this.providers = statisticsProviders;
    }

    public void setStatisticsProviderExternalRecords(Collection<StatisticsProviderExternalRecords> statisticsProviders) {
        this.providerExternalRecords = statisticsProviders;
    }

    public void setStatisticsConsumers(Collection<StatisticsConsumer> statisticsConsumers) {
        this.statisticsConsumers = statisticsConsumers;
    }

    public void setStatisticsConsumerWorkerPool(ExecutorService statisticsConsumerWorkerPool) {
        this.statisticsConsumerWorkerPool = statisticsConsumerWorkerPool;
    }

    public void requestStarted(Collection<StatisticsProvider> additionalProviders, Collection<StatisticsProviderExternalRecords> additionalProvidersExternalRecords) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "StatisticsTracingHandler: requestStarted ...");
        }
        if (this.providers != null) {
            for (StatisticsProvider statisticsProvider : this.providers) {
                statisticsProvider.requestStarted();
            }
        }
        if (additionalProviders != null) {
            for (StatisticsProvider statisticsProvider : additionalProviders) {
                statisticsProvider.requestStarted();
            }
        }
        if (this.providerExternalRecords != null) {
            for (StatisticsProviderExternalRecords statisticsProviderExternalRecords : this.providerExternalRecords) {
                statisticsProviderExternalRecords.requestStarted();
            }
        }
        if (additionalProvidersExternalRecords != null) {
            for (StatisticsProviderExternalRecords statisticsProviderExternalRecords : additionalProvidersExternalRecords) {
                statisticsProviderExternalRecords.requestStarted();
            }
        }
    }

    public void requestFinished(StatisticsThreadContext ctx) {
        Collection<StatisticsProviderExternalRecords> additionalProvidersExternalRecords;
        Collection<StatisticsProvider> additionalProviders;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "StatisticsTracingHandler: requestFinished ...");
        }
        DSRMainRecord mainRec = this.createDSRMainRecord(ctx);
        if (this.providers != null) {
            for (StatisticsProvider provider : this.providers) {
                provider.requestFinished();
                provider.writeTo(mainRec);
            }
        }
        if ((additionalProviders = ctx.getAdditionalStatisticsProviders()) != null) {
            for (StatisticsProvider provider : additionalProviders) {
                provider.requestFinished();
                provider.writeTo(mainRec);
            }
        }
        long externalTime = 0L;
        DSRRecord record = new DSRRecord();
        if (this.providerExternalRecords != null) {
            for (StatisticsProviderExternalRecords provider : this.providerExternalRecords) {
                Set records = provider.requestFinished();
                for (DSRExternalRecord subRec : records) {
                    record.addSubRecord(subRec);
                    externalTime += subRec.getCallTime();
                }
            }
        }
        if ((additionalProvidersExternalRecords = ctx.getAdditionalStatisticsProvidersExternalRecords()) != null) {
            for (StatisticsProviderExternalRecords provider : additionalProvidersExternalRecords) {
                Set records = provider.requestFinished();
                for (DSRExternalRecord subRec : records) {
                    record.addSubRecord(subRec);
                    externalTime += subRec.getCallTime();
                }
            }
        }
        mainRec.setExtTime(externalTime);
        record.setMainRecord(mainRec);
        record.setHttpRecord(ctx.getDsrHttpRecord());
        DSRPassport passport = ctx.getPassport();
        if (passport != null) {
            record.setPassport(passport);
        }
        ctx.setPassport(null);
        this.invokeStatisticsConsumers((DSRIRecord)record);
    }

    private DSRMainRecord createDSRMainRecord(StatisticsThreadContext ctx) {
        DSRPassport passport;
        String userId = ctx.getUserId();
        if (userId == null) {
            userId = "n.a.";
        }
        String transId = (passport = ctx.getPassport()) == null ? "n.a." : passport.getTransId();
        return new DSRMainRecord(transId, ctx.getAction(), userId, ctx.getAccount(), null, ctx.getStartTime(), 0, 0, ctx.getProcessingTime(), ctx.getCpuTime() / 1000000L, ctx.getMemoryConsumption(), 0L, 0L, ctx.getReceivedBytes(), ctx.getSentBytes());
    }

    private void invokeStatisticsConsumers(DSRIRecord dsriRecord) {
        if (this.statisticsConsumerWorkerPool == null) {
            logger.log(Level.SEVERE, "The statistics consumer worker pool is not initialized!");
            return;
        }
        this.statisticsConsumerWorkerPool.execute(new StatisticsReportTask(this.statisticsConsumers, dsriRecord));
    }
}

