/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.impl.providers;

import com.sap.js.statistics.api.StatisticsTrigger;
import com.sap.js.statistics.impl.providers.RequestTracingValveHandler;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.catalina.connector.Request;

public final class StatisticsTriggerProvider {
    private static final Collection<StatisticsTrigger> statisticsTriggers = new LinkedList<StatisticsTrigger>();
    private static volatile StatisticsTrigger statisticsTriggerCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatisticsTrigger getStatisticsTrigger() {
        StatisticsTrigger statisticsTrigger = statisticsTriggerCache;
        if (statisticsTrigger != null) return statisticsTrigger;
        Class<StatisticsTriggerProvider> clazz = StatisticsTriggerProvider.class;
        synchronized (StatisticsTriggerProvider.class) {
            if (statisticsTriggerCache != null) return statisticsTriggerCache;
            statisticsTriggerCache = new CompositeStatisticsTrigger(statisticsTriggers);
            return statisticsTriggerCache;
        }
    }

    public static synchronized void addStatisticsTrigger(StatisticsTrigger statisticsTrigger) {
        statisticsTriggerCache = null;
        statisticsTriggers.add(statisticsTrigger);
    }

    public static synchronized void removeStatisticsTrigger(StatisticsTrigger statisticsTrigger) {
        statisticsTriggerCache = null;
        statisticsTriggers.remove(statisticsTrigger);
    }

    public static void bindStatisticsTrigger(StatisticsTrigger statisticsTrigger) {
        StatisticsTriggerProvider.addStatisticsTrigger(statisticsTrigger);
    }

    public static void unbindStatisticsTrigger(StatisticsTrigger statisticsTrigger) {
        StatisticsTriggerProvider.removeStatisticsTrigger(statisticsTrigger);
    }

    private static final class CompositeStatisticsTrigger
    implements StatisticsTrigger {
        private final StatisticsTrigger[] triggers;

        public CompositeStatisticsTrigger(Collection<StatisticsTrigger> triggers) {
            Iterator<StatisticsTrigger> triggerIterator = triggers.iterator();
            this.triggers = new StatisticsTrigger[triggers.size()];
            int i = 0;
            while (i < this.triggers.length) {
                this.triggers[i] = triggerIterator.next();
                ++i;
            }
        }

        public boolean shouldEnableStatistics(Request request) {
            RequestTracingValveHandler requestTracingValveHandler = RequestTracingValveHandler.getInstance();
            if (requestTracingValveHandler.hasStatisticsTracingHandler()) {
                StatisticsTrigger[] statisticsTriggerArray = this.triggers;
                int n = this.triggers.length;
                int n2 = 0;
                while (n2 < n) {
                    StatisticsTrigger trigger = statisticsTriggerArray[n2];
                    if (trigger.shouldEnableStatistics(request)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }
}

