/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.impl.providers.trace;

import com.sap.js.statistics.impl.providers.trace.LoggingTraceFilterImpl;
import com.sap.js.statistics.impl.providers.trace.TraceService;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class TraceManagedService
implements ManagedService {
    public static final String TRACE_PROP = "session.trace";
    private static final String SERVICE_PID = "service.pid";
    private static final Logger logger = Logger.getLogger(TraceManagedService.class);

    public void updated(Dictionary np) throws ConfigurationException {
        logger.info((Object)"Updating trace configuration...");
        if (np != null) {
            Properties traceProps = new Properties();
            Enumeration en = np.keys();
            boolean enable = false;
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("TraceManagedService - key: " + key));
                    logger.info((Object)("TraceManagedService - value: " + np.get(key)));
                }
                if (key.equalsIgnoreCase(TRACE_PROP)) {
                    if (!"on".equalsIgnoreCase((String)np.get(key))) continue;
                    enable = true;
                    continue;
                }
                if (key.equalsIgnoreCase(SERVICE_PID)) continue;
                traceProps.put(key, (String)np.get(key));
            }
            logger.info((Object)"Updating configuration...");
            if (enable) {
                this.enableTracing(traceProps);
            } else {
                this.disableTracing();
            }
        }
    }

    private void enableTracing(Properties properties) {
        String[] loggers = new String[properties.size()];
        String[] levels = new String[properties.size()];
        if (!properties.isEmpty()) {
            int index = 0;
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String key;
                loggers[index] = key = (String)e.nextElement();
                levels[index] = (String)properties.get(key);
                ++index;
            }
        } else {
            loggers = new String[1];
            levels = new String[1];
            loggers[0] = Logger.getRootLogger().getName();
            levels[0] = Level.ALL.toString();
        }
        this.disableTracing();
        TraceService.startSessionTrace(loggers, levels, new LoggingTraceFilterImpl());
    }

    private void disableTracing() {
        TraceService.stopSessionTrace();
    }
}

