/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.impl.providers.trace;

import com.sap.core.js.logging.trace.LoggingTraceFilter;
import com.sap.core.js.logging.trace.LoggingTraceService;
import org.apache.log4j.Logger;

public class TraceService {
    private static LoggingTraceService traceService;
    private static final Logger logger;
    private static boolean mustStart;
    private static boolean mustStop;
    private static String[] loggers;
    private static String[] levels;
    private static LoggingTraceFilter filter;

    static {
        logger = Logger.getLogger(TraceService.class);
    }

    public void serviceAvailable(LoggingTraceService loggingTraceService) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"serviceAvailable");
        }
        traceService = loggingTraceService;
        if (mustStart) {
            traceService.startSessionTrace(loggers, levels, filter);
            mustStart = false;
        } else if (mustStop) {
            traceService.stopSessionTrace();
            mustStop = false;
        }
    }

    public void serviceUnAvailable(LoggingTraceService loggingTraceService) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"serviceUnAvailable");
        }
        traceService = null;
    }

    public static void startSessionTrace(String[] loggers_, String[] levels_, LoggingTraceFilter filter_) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"startSessionTrace called");
        }
        if (traceService != null) {
            traceService.startSessionTrace(loggers_, levels_, filter_);
        } else {
            loggers = loggers_;
            levels = levels_;
            filter = filter_;
            mustStart = true;
        }
    }

    public static void stopSessionTrace() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"stopSessionTrace called");
        }
        if (traceService != null) {
            traceService.stopSessionTrace();
        } else {
            mustStop = true;
        }
    }
}

