/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.impl.threading;

import com.sap.js.statistics.api.DSRIMainRecord;
import com.sap.js.statistics.api.DSRIRecord;
import com.sap.js.statistics.impl.threading.StatisticsReportTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class StatisticsRejectionHandler
implements RejectedExecutionHandler {
    private static final Logger logger = Logger.getLogger(StatisticsReportTask.class.getName());
    private static final String UNKNOWN_VALUE = "[unknown]";
    private final LoggingStrategy loggingStrategy;

    public StatisticsRejectionHandler(LoggingStrategy loggingStrategy) {
        if (loggingStrategy == null) {
            throw new IllegalArgumentException("The logging strategy cannot be null.");
        }
        this.loggingStrategy = loggingStrategy;
    }

    @Override
    public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
        this.loggingStrategy.logRejectedExecution(runnable, executor);
    }

    private static void logRejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
        if (runnable instanceof StatisticsReportTask) {
            StatisticsReportTask reportTask = (StatisticsReportTask)runnable;
            DSRIRecord dsriRecord = reportTask.getDsriRecord();
            logger.log(Level.SEVERE, "Failed to report JDSR statistics for transaction: " + StatisticsRejectionHandler.getTransactionId(dsriRecord) + " because the queue is full: " + executor.getQueue().size());
        } else {
            logger.log(Level.SEVERE, "Failed to report JDSR statistics because the queue is full: " + executor.getQueue().size());
        }
    }

    private static String getTransactionId(DSRIRecord dsriRecord) {
        if (dsriRecord == null) {
            return UNKNOWN_VALUE;
        }
        DSRIMainRecord mainRecord = dsriRecord.getMainRecord();
        if (mainRecord == null) {
            return UNKNOWN_VALUE;
        }
        String transactionId = mainRecord.getTransId();
        if (transactionId == null || transactionId.isEmpty()) {
            return UNKNOWN_VALUE;
        }
        return transactionId;
    }

    public static final class LogEverythingStrategy
    implements LoggingStrategy {
        @Override
        public void logRejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            StatisticsRejectionHandler.logRejectedExecution(runnable, executor);
        }
    }

    public static interface LoggingStrategy {
        public void logRejectedExecution(Runnable var1, ThreadPoolExecutor var2);
    }

    public static final class NoOpLoggingStrategy
    implements LoggingStrategy {
        @Override
        public void logRejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
        }
    }

    public static final class PartialLoggingStrategy
    implements LoggingStrategy {
        private final AtomicInteger rejections;
        private final int loggingFrequency;

        public PartialLoggingStrategy(int loggingFrequency) {
            if (loggingFrequency <= 1) {
                throw new IllegalArgumentException("Invalid logging frequency: " + loggingFrequency);
            }
            this.loggingFrequency = loggingFrequency;
            this.rejections = new AtomicInteger();
        }

        @Override
        public void logRejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            int count = this.rejections.incrementAndGet();
            if (count % this.loggingFrequency == 0) {
                this.rejections.set(0);
                StatisticsRejectionHandler.logRejectedExecution(runnable, executor);
            }
        }
    }
}

