/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.impl.threading;

import com.sap.js.statistics.api.DSRIMainRecord;
import com.sap.js.statistics.api.DSRIRecord;
import com.sap.js.statistics.api.StatisticsConsumer;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class StatisticsReportTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(StatisticsReportTask.class.getName());
    private static final String UNKNOWN_VALUE = "[unknown]";
    private final Collection<StatisticsConsumer> statisticsConsumers;
    private final DSRIRecord dsriRecord;

    public StatisticsReportTask(Collection<StatisticsConsumer> statisticsConsumers, DSRIRecord dsriRecord) {
        this.statisticsConsumers = statisticsConsumers;
        this.dsriRecord = dsriRecord;
    }

    @Override
    public void run() {
        for (StatisticsConsumer statisticsConsumer : this.statisticsConsumers) {
            this.invokeConsumer(statisticsConsumer, this.dsriRecord);
        }
    }

    private void invokeConsumer(StatisticsConsumer statisticsConsumer, DSRIRecord dsriRecord) {
        try {
            statisticsConsumer.requestFinished(dsriRecord);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Statistics consumer failed for transaction id: " + this.getTransactionId(dsriRecord), exception);
        }
    }

    private String getTransactionId(DSRIRecord dsriRecord) {
        if (dsriRecord == null) {
            return UNKNOWN_VALUE;
        }
        DSRIMainRecord mainRecord = dsriRecord.getMainRecord();
        if (mainRecord == null) {
            return UNKNOWN_VALUE;
        }
        String transactionId = mainRecord.getTransId();
        if (transactionId == null || transactionId.isEmpty()) {
            return UNKNOWN_VALUE;
        }
        return transactionId;
    }

    public DSRIRecord getDsriRecord() {
        return this.dsriRecord;
    }
}

