/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.lifecycle;

import com.sap.cloud.runtime.impl.bridge.ClassloadingBridge;
import com.sap.core.services.accessor.lifecycle.InternalComponentLifecycle;
import com.sap.js.statistics.api.StatisticsConsumer;
import com.sap.js.statistics.api.StatisticsTrigger;
import com.sap.js.statistics.impl.StatisticsLifecycleHandler;
import com.sap.js.statistics.impl.providers.StatisticsConsumerProvider;
import com.sap.js.statistics.impl.providers.StatisticsProviderService;
import com.sap.js.statistics.impl.providers.StatisticsTriggerProvider;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;

public class StatisticsLifecycle
implements InternalComponentLifecycle {
    private StatisticsLifecycleHandler statisticsLifecycleHandler;
    private static final Logger logger = Logger.getLogger(StatisticsLifecycle.class);

    public void start() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting statistics component from com.sap.core.services.accessor.lifecycle.InternalComponentLifecycle.");
        }
        ClassLoader implClassLoader = ClassloadingBridge.getImplClassLoader();
        this.registerServiceLoaderProvidedStatisticsTriggers(implClassLoader);
        this.registerServiceLoaderProvidedStatisticsConsumers(implClassLoader);
        if (this.statisticsLifecycleHandler == null) {
            this.statisticsLifecycleHandler = new StatisticsLifecycleHandler();
        }
        this.statisticsLifecycleHandler.start();
        StatisticsProviderService.setImplClassLoader(implClassLoader);
    }

    private void registerServiceLoaderProvidedStatisticsTriggers(ClassLoader implClassLoader) {
        ServiceLoader<StatisticsTrigger> statisticsTriggers = ServiceLoader.load(StatisticsTrigger.class, implClassLoader);
        for (StatisticsTrigger statisticsTrigger : statisticsTriggers) {
            StatisticsTriggerProvider.addStatisticsTrigger(statisticsTrigger);
        }
    }

    private void registerServiceLoaderProvidedStatisticsConsumers(ClassLoader implClassLoader) {
        ServiceLoader<StatisticsConsumer> statisticsConsumers = ServiceLoader.load(StatisticsConsumer.class, implClassLoader);
        for (StatisticsConsumer statisticsConsumer : statisticsConsumers) {
            StatisticsConsumerProvider.addStatisticsConsumer(statisticsConsumer);
        }
    }

    public void stop() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Stopping statistics component from com.sap.core.services.accessor.lifecycle.InternalComponentLifecycle.");
        }
        if (this.statisticsLifecycleHandler != null) {
            this.statisticsLifecycleHandler.stop();
        }
        StatisticsProviderService.setImplClassLoader(null);
    }

    protected void setStatisticsLifecycleHandler(StatisticsLifecycleHandler slh) {
        this.statisticsLifecycleHandler = slh;
    }
}

