/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.auth.local.callbackhandler;

import com.sap.core.jpaas.security.auth.lib.callback.AuthnStateCallback;
import com.sap.core.jpaas.security.auth.lib.callbackhandler.AbstractWebCallbackHandler;
import com.sap.engine.lib.security.http.HttpGetterCallback;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.coyote.ActionCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalWebCallbackHandler
extends AbstractWebCallbackHandler {
    public static final Logger LOG = LoggerFactory.getLogger(LocalWebCallbackHandler.class);
    private static final String LOGIN_PAGE = "/ide/login/pages/hana_login.jsp";
    private static final String CLIENT_CERT_ATTRIBUTE_NAME = "javax.servlet.request.X509Certificate";

    public LocalWebCallbackHandler() {
        super("SAP HANA Cloud Platform (Local Server)");
    }

    protected void handle(HttpGetterCallback callback) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entering method handle() with " + callback);
        }
        switch (callback.getType()) {
            case 4: {
                Object value;
                String name = callback.getName();
                if (name == null) {
                    name = CLIENT_CERT_ATTRIBUTE_NAME;
                }
                if ((value = this.request.getAttribute(name)) == null && this.request instanceof Request) {
                    ((Request)this.request).getCoyoteRequest().action(ActionCode.REQ_SSL_CERTIFICATE, null);
                    value = this.request.getAttribute(name);
                }
                callback.setValue(value);
                break;
            }
            default: {
                super.handle(callback);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exiting method handle() with " + callback);
        }
    }

    protected void handle(AuthnStateCallback callback) throws IOException {
        if (!this.response.isCommitted()) {
            switch (callback) {
                case LOGIN_OK: {
                    if (!this.shouldRestoreOriginalRequest()) break;
                    this.restoreOriginalRequest();
                    break;
                }
                case LOGIN_FAILED: {
                    if (!this.canSendCredentialsRequest()) break;
                    if (!this.authMethod.startsWith("BASIC")) {
                        if (!this.request.getRequestURI().endsWith("/j_security_check")) {
                            if (this.request.getRequestURI().contains("pages")) break;
                            this.preserveOriginalRequestInCookie();
                            LOG.debug("Forward to login page.");
                            this.forwardToLoginPage();
                            break;
                        }
                        LOG.debug("Forward to error page.");
                        this.forwardToErrorPage();
                        break;
                    }
                    this.askForBasicCredentials();
                    break;
                }
            }
            this.handleDelayedSetterCallback();
        }
    }

    private void forwardToErrorPage() throws IOException {
        try {
            Context catalina = ((Request)this.request).getContext();
            if (this.errorPage != null && this.errorPage.length() != 0) {
                LOG.debug("Forward to application's error page.");
                RequestDispatcher disp = catalina.getServletContext().getRequestDispatcher(this.errorPage);
                disp.forward((ServletRequest)this.request, (ServletResponse)this.response);
            } else {
                LOG.debug("Forward to default login page.");
                this.forwardToLoginPage();
            }
        }
        catch (ServletException e) {
            throw new IOException(e);
        }
    }

    private void forwardToLoginPage() throws IOException {
        try {
            Context catalina = ((Request)this.request).getContext();
            if (this.loginPage != null && this.loginPage.length() != 0) {
                LOG.debug("Forward to application's login page.");
                RequestDispatcher disp = catalina.getServletContext().getRequestDispatcher(this.loginPage);
                disp.forward((ServletRequest)this.request, (ServletResponse)this.response);
            } else {
                LOG.debug("Forward to default login page.");
                catalina.getServletContext().getRequestDispatcher(LOGIN_PAGE).forward((ServletRequest)this.request, (ServletResponse)this.response);
            }
        }
        catch (ServletException e) {
            throw new IOException(e);
        }
    }
}

