/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.impl.util.connectivity;

import com.sap.jpaas.service.securestore.local.keystore.LocalKeystoreService;
import com.sap.jpaas.service.securestore.local.keystore.internal.LocalKeystoreInitializer;
import com.sap.jpaas.service.securestore.local.keystore.internal.LocalKeystoreServiceImpl;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCertificate {
    static final String VM_CERT_ALIAS = "vm_cert";
    private static final String PROTOCOL_TYPE = "TLSv1.2";
    private static final Logger log = LoggerFactory.getLogger(ClientCertificate.class);
    private SSLSocketFactory socketFactory;

    public ClientCertificate() {
        try {
            this.socketFactory = this.createSSLSocketFactory();
            if (this.socketFactory == null) {
                throw new RuntimeException("Could not create socket factory, was null.");
            }
            log.info("Created socket factory");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create socket factory: " + e.getMessage(), e);
        }
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.socketFactory;
    }

    SSLSocketFactory createSSLSocketFactory() throws GeneralSecurityException, IOException, ClassNotFoundException {
        LocalKeystoreService lksService = this.getLocalKeystoreService();
        if (lksService == null) {
            log.error("LocalKeystoreService reference was null");
            return null;
        }
        KeyStore.Entry vmcertEntry = lksService.getEntry(VM_CERT_ALIAS);
        if (vmcertEntry == null) {
            log.error("VM Certificate Entry was null");
            return null;
        }
        char[] passwd = new char[20];
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < passwd.length; ++i) {
            passwd[i] = (char)random.nextInt(65535);
        }
        KeyStore newKeystore = KeyStore.getInstance("JKS");
        newKeystore.load(null, passwd);
        newKeystore.setEntry("clientCert", vmcertEntry, new KeyStore.PasswordProtection(passwd));
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(newKeystore, passwd);
        SSLContext ctx = SSLContext.getInstance(PROTOCOL_TYPE);
        ctx.init(keyManagerFactory.getKeyManagers(), null, null);
        return ctx.getSocketFactory();
    }

    LocalKeystoreService getLocalKeystoreService() throws IOException, GeneralSecurityException {
        LocalKeystoreServiceImpl lksService = null;
        try {
            lksService = LocalKeystoreInitializer.createActivationObject(null);
        }
        catch (InterruptedException e) {
            log.error("LocalKeystoreInitializer fails to create an object", (Throwable)e);
        }
        return lksService;
    }
}

