/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.impl.util.connectivity;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.sap.cloud.runtime.impl.util.connectivity.HttpConnectionSetupHelper;
import com.sap.cloud.runtime.impl.util.connectivity.LruCache;
import com.sap.cloud.runtime.impl.util.connectivity.TTLCacheEntry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalConfigurationServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(LocalConfigurationServiceHelper.class);
    static final String CONFIG_SERVER_PORT_PROP = "config.server.port";
    static final String REQUEST_URL = "http://localhost:%s/config/v1/services/connectivity/%s";
    static final String BASIC_ERROR_MESSAGE = "Could not retrieve %s destination";
    static final String TIMEOUT_ERROR_MESSAGE = "Connection to local configuration service times out: ";
    static final Map<String, TTLCacheEntry<Properties>> cachedDestinations = Collections.synchronizedMap(new LruCache(8));
    static final long CACHE_ENTRY_MAX_AGE_MILLIS = 300000L;

    public static Properties getDestinationProperties(String destinationName) {
        Properties destinationProperties;
        TTLCacheEntry<Properties> cachedDestination = cachedDestinations.get(destinationName);
        if (null == cachedDestination || cachedDestination.hasExpired()) {
            if (log.isDebugEnabled()) {
                log.debug("Retrieving <{}> destination from local configuration service.", (Object)destinationName);
            }
            destinationProperties = LocalConfigurationServiceHelper.getDestinationPropsFromLocalConfigService(destinationName);
            cachedDestination = new TTLCacheEntry<Properties>(destinationProperties, 300000L);
            cachedDestinations.put(destinationName, cachedDestination);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Retrieving <{}> destination from cache.", (Object)destinationName);
            }
            destinationProperties = cachedDestination.getValue();
        }
        if (log.isDebugEnabled()) {
            log.debug("Retrieved destination properties: {}", (Object)destinationProperties);
        }
        return destinationProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getDestinationPropsFromLocalConfigService(String destinationName) {
        if (!LocalConfigurationServiceHelper.isDestinationNameValid(destinationName)) {
            log.error("Destination name not provided");
            return null;
        }
        String urlString = LocalConfigurationServiceHelper.constructRequestUrl(destinationName);
        HttpURLConnection connection = null;
        try {
            connection = LocalConfigurationServiceHelper.createConnection(urlString);
            Properties properties = LocalConfigurationServiceHelper.readPropertiesFromResponse(connection);
            return properties;
        }
        catch (SocketTimeoutException e) {
            LocalConfigurationServiceHelper.traceError(e, destinationName, TIMEOUT_ERROR_MESSAGE);
            Properties properties = null;
            return properties;
        }
        catch (IOException e) {
            LocalConfigurationServiceHelper.traceError(e, destinationName);
            Properties properties = null;
            return properties;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    static boolean isDestinationNameValid(String destinationName) {
        return destinationName != null && !destinationName.isEmpty();
    }

    static String constructRequestUrl(String destinationName) {
        String port = System.getProperty(CONFIG_SERVER_PORT_PROP);
        String urlString = String.format(REQUEST_URL, port, destinationName);
        return urlString;
    }

    static void traceError(IOException e, String ... params) {
        log.error(String.format(BASIC_ERROR_MESSAGE, params[0]) + (params.length > 1 ? ". " + params[1] : ": "), (Throwable)e);
    }

    static HttpURLConnection createConnection(String urlString) throws MalformedURLException, IOException {
        URL connectionUrl = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)connectionUrl.openConnection();
        LocalConfigurationServiceHelper.initializeConnectionProperties(connection);
        return connection;
    }

    static void initializeConnectionProperties(HttpURLConnection connection) throws ProtocolException {
        HttpConnectionSetupHelper.setRequestMethod(connection);
        HttpConnectionSetupHelper.setAcceptHeader(connection);
        HttpConnectionSetupHelper.setConnectTimeout(connection);
        HttpConnectionSetupHelper.setReadTimeout(connection);
    }

    static Properties readPropertiesFromResponse(HttpURLConnection connection) throws IOException, JsonSyntaxException {
        String line;
        Properties properties = null;
        int responseCode = connection.getResponseCode();
        if (responseCode < 200 || responseCode >= 400) {
            throw new IOException("Failed to get destination, http status code " + responseCode + " for URL " + connection.getURL());
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line);
        }
        reader.close();
        String rawProperties = builder.toString();
        if (null == rawProperties || rawProperties.isEmpty() || rawProperties.equals("null")) {
            throw new IOException("Failed to get destination, empty response for URL " + connection.getURL());
        }
        if (log.isInfoEnabled()) {
            log.info("Raw properties read: " + rawProperties);
        }
        properties = (Properties)new Gson().fromJson(rawProperties, Properties.class);
        return properties;
    }
}

