/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.impl.util.connectivity;

import java.util.LinkedHashMap;
import java.util.Map;

final class LruCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private static final int INITIAL_CAPACITY = 2;
    private static final float LOAD_FACTOR = 0.75f;
    private static final boolean ACCESS_ORDER = true;
    private final int capacity;

    public LruCache(int capacity) {
        super(2, 0.75f, true);
        if (0 >= capacity) {
            throw new IllegalArgumentException("Invalid cache capacity: " + capacity);
        }
        this.capacity = capacity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.capacity;
    }

    @Override
    public String toString() {
        return "LruCache [capacity=" + this.capacity + ", toString()=" + super.toString() + "]";
    }
}

