/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.impl.util.connectivity;

import com.sap.cloud.runtime.impl.util.connectivity.ClientCertificate;
import com.sap.cloud.runtime.impl.util.connectivity.HttpConnectionSetupHelper;
import com.sap.cloud.runtime.impl.util.connectivity.LocalConfigurationServiceHelper;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnectionInitializer {
    private static final Logger log = LoggerFactory.getLogger(ServerConnectionInitializer.class);

    public static HttpURLConnection createConnection(String destinationName, String requestPath, String token, String tenantId) throws IOException {
        HttpURLConnection connection;
        Properties destinationProperties = LocalConfigurationServiceHelper.getDestinationProperties(destinationName);
        String destinationUrl = null;
        String proxy = null;
        if (destinationProperties == null) {
            String message = "Local configuration service failed to find properties for destination " + destinationName + ".";
            ServerConnectionInitializer.logDebugMessage(message, null);
            throw new IOException(message);
        }
        destinationUrl = destinationProperties.getProperty("URL");
        proxy = destinationProperties.getProperty("SystemProxy");
        ServerConnectionInitializer.validateDestinationUrl(destinationUrl);
        destinationUrl = destinationUrl + requestPath;
        URL url = new URL(destinationUrl);
        ClientCertificate clientCert = null;
        if (ServerConnectionInitializer.requiresSecureConnection(destinationProperties)) {
            clientCert = new ClientCertificate();
        }
        if (proxy == null || proxy.isEmpty()) {
            connection = ServerConnectionInitializer.initConnection(url, clientCert, null, null);
        } else {
            int index = proxy.indexOf(":");
            if (index == -1) {
                ServerConnectionInitializer.logDebugMessage("Invalid proxy property: " + proxy, null);
                connection = ServerConnectionInitializer.initConnection(url, clientCert, null, null);
            }
            String proxyHost = proxy.substring(0, index);
            String proxyPort = proxy.substring(index + 1);
            connection = ServerConnectionInitializer.initConnection(url, clientCert, proxyHost, proxyPort);
        }
        return connection;
    }

    static boolean requiresSecureConnection(Properties destinationProperties) {
        return "InternalSystemAuthentication".equals(destinationProperties.getProperty("Authentication"));
    }

    static void validateDestinationUrl(String destinationUrl) throws IOException {
        if (destinationUrl == null || destinationUrl.isEmpty()) {
            String message = "Missing destination URL";
            ServerConnectionInitializer.logDebugMessage(message, null);
            throw new IOException(message);
        }
    }

    static HttpURLConnection initConnection(URL url, ClientCertificate clientCert, String proxyHost, String proxyPort) throws IOException {
        Proxy proxy = ServerConnectionInitializer.getProxy(proxyHost, proxyPort, url);
        URLConnection urlc = url.openConnection(proxy);
        if (urlc instanceof HttpURLConnection) {
            HttpURLConnection connection = (HttpURLConnection)urlc;
            ServerConnectionInitializer.initializeConnectionProperties(connection);
            ServerConnectionInitializer.setSSLSocketFactory(connection, clientCert);
            return connection;
        }
        throw new IOException("Unable to connect to server");
    }

    static void initializeConnectionProperties(HttpURLConnection connection) throws ProtocolException {
        HttpConnectionSetupHelper.setRequestMethod(connection);
        HttpConnectionSetupHelper.setConnectTimeout(connection);
        HttpConnectionSetupHelper.setReadTimeout(connection);
    }

    static Proxy getProxy(String proxyHost, String proxyPort, URL target) throws IOException {
        if (proxyHost != null && proxyPort != null) {
            try {
                int proxyportInt = new Integer(proxyPort);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyportInt));
                return proxy;
            }
            catch (NumberFormatException e) {
                String message = "The proxy port is set to a non-integer value. If the server is behind proxy it will not be visible and the authentication will fail.";
                ServerConnectionInitializer.logDebugMessage(message, e);
                throw new IOException(message, e);
            }
        }
        if (proxyHost == null) {
            return ServerConnectionInitializer.determineProxy(target);
        }
        return Proxy.NO_PROXY;
    }

    static Proxy determineProxy(URL target) {
        URI uri;
        ProxySelector proxySelector = ProxySelector.getDefault();
        try {
            uri = target.toURI();
        }
        catch (URISyntaxException e) {
            return Proxy.NO_PROXY;
        }
        List<Proxy> proxies = proxySelector.select(uri);
        return ServerConnectionInitializer.pickProxy(proxies);
    }

    static Proxy pickProxy(List<Proxy> proxies) {
        for (Proxy proxy : proxies) {
            if (proxy.type() != Proxy.Type.DIRECT && proxy.type() != Proxy.Type.HTTP) continue;
            return proxy;
        }
        return Proxy.NO_PROXY;
    }

    static void setSSLSocketFactory(URLConnection urlc, ClientCertificate clientCert) {
        SSLSocketFactory sf;
        if (urlc instanceof HttpsURLConnection && clientCert != null && (sf = clientCert.getSSLSocketFactory()) != null) {
            ((HttpsURLConnection)urlc).setSSLSocketFactory(sf);
        }
    }

    static void logDebugMessage(String message, Exception e) {
        if (!log.isDebugEnabled()) {
            return;
        }
        if (e == null) {
            log.debug(message);
        } else {
            log.debug(message, (Throwable)e);
        }
    }
}

