/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.impl.util.connectivity;

final class TTLCacheEntry<T> {
    private final long creationTime;
    private final long maxAgeMillis;
    private final T value;

    public TTLCacheEntry(T value) {
        this(value, 0L);
    }

    public TTLCacheEntry(T value, long maxAgeMillis) {
        this.value = value;
        this.maxAgeMillis = maxAgeMillis;
        this.creationTime = System.currentTimeMillis();
    }

    public T getValue() {
        return this.value;
    }

    public boolean hasExpired() {
        return System.currentTimeMillis() - this.creationTime > this.maxAgeMillis;
    }

    public String toString() {
        return "TTLCacheEntry [creationTime=" + this.creationTime + ", maxAgeMillis=" + this.maxAgeMillis + ", value=" + this.value + "]";
    }
}

