/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.common;

import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.naming.ResourceRef;
import org.apache.openejb.core.ivm.naming.JaxWsServiceReference;
import org.apache.tomee.common.AbstractObjectFactory;
import org.apache.tomee.common.NamingUtil;

public class WsFactory
extends AbstractObjectFactory {
    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable environment) throws Exception {
        Object value;
        if (!(object instanceof ResourceRef)) {
            return null;
        }
        Reference ref = (Reference)object;
        if (NamingUtil.getProperty(ref, "jndiname") != null) {
            value = super.getObjectInstance(object, name, context, environment);
        } else {
            List injections;
            List handlerChains;
            List portRefs;
            String serviceClassName = NamingUtil.getProperty(ref, "wsclass");
            Class<Service> serviceClass = Service.class;
            if (serviceClassName != null && (serviceClass = NamingUtil.loadClass(serviceClassName).asSubclass(Service.class)) == null) {
                throw new NamingException("Could not load service type class " + serviceClassName);
            }
            Class<?> referenceClass = NamingUtil.loadClass(ref.getClassName());
            if (referenceClass != null && Service.class.isAssignableFrom(referenceClass)) {
                serviceClass = referenceClass.asSubclass(Service.class);
            }
            String serviceId = NamingUtil.getProperty(ref, "wsid");
            QName serviceQName = null;
            if (NamingUtil.getProperty(ref, "wsqname") != null) {
                serviceQName = QName.valueOf(NamingUtil.getProperty(ref, "wsqname"));
            }
            URL wsdlUrl = null;
            if (NamingUtil.getProperty(ref, "wsdlurl") != null) {
                wsdlUrl = new URL(NamingUtil.getProperty(ref, "wsdlurl"));
            }
            QName portQName = null;
            if (NamingUtil.getProperty(ref, "wsportqname") != null) {
                portQName = QName.valueOf(NamingUtil.getProperty(ref, "wsportqname"));
            }
            if ((portRefs = (List)NamingUtil.getStaticValue(ref, "port-refs")) == null) {
                portRefs = Collections.emptyList();
            }
            if ((handlerChains = (List)NamingUtil.getStaticValue(ref, "handler-chains")) == null) {
                handlerChains = Collections.emptyList();
            }
            if ((injections = (List)NamingUtil.getStaticValue(ref, "injections")) == null) {
                injections = Collections.emptyList();
            }
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)environment);
            JaxWsServiceReference serviceReference = new JaxWsServiceReference(serviceId, serviceQName, serviceClass, portQName, referenceClass, wsdlUrl, portRefs, handlerChains, injections, properties);
            value = serviceReference.getObject();
        }
        return value;
    }

    @Override
    protected String buildJndiName(Reference reference) throws NamingException {
        throw new UnsupportedOperationException();
    }
}

