/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jpaas.infrastructure.console;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;

public class CmdJarsClassLoader
extends URLClassLoader {
    private static final String JAVA_VM_NAME = "java.vm.name";
    public static final String NEO_PROCESS_NAME = "neo.process.name";
    public static final String NEO_BASE_LOCATION = "neo.base.location";
    public static final String JAVA_CLASS_PATH = "java.class.path";
    public static final String NEO_COMMAND_NAME = "neo.command.name";

    public CmdJarsClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        String jarsDirPath = System.getProperty(NEO_BASE_LOCATION) + File.separator + "lib" + File.separator + "cmd";
        String classPath = System.getProperty(JAVA_CLASS_PATH);
        ArrayList<String> classPathEntries = new ArrayList<String>(CmdJarsClassLoader.parseClassPath(classPath));
        classPathEntries.add(jarsDirPath);
        File jarsDir = new File(jarsDirPath);
        CmdJarsClassLoader.addJars(classPathEntries, jarsDir);
        for (String classPathEntry : classPathEntries) {
            try {
                super.addURL(new File(classPathEntry).toURI().toURL());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String newClassPath = CmdJarsClassLoader.constructClassPath(classPathEntries);
        System.setProperty(JAVA_CLASS_PATH, newClassPath);
        this.initializeProcessId();
    }

    private void initializeProcessId() {
        String jvmName = System.getProperty(JAVA_VM_NAME);
        String commandName = System.getProperty(NEO_COMMAND_NAME, jvmName);
        String logFileSuffix = commandName + "_" + System.currentTimeMillis();
        String propertyValue = System.getProperty(NEO_PROCESS_NAME, logFileSuffix).replaceAll("[^a-zA-Z0-9.-]", "_");
        System.setProperty(NEO_PROCESS_NAME, propertyValue);
    }

    private static List<String> parseClassPath(String classPath) {
        if (classPath != null) {
            return Arrays.asList(classPath.split(File.pathSeparator));
        }
        return Collections.emptyList();
    }

    private static String constructClassPath(List<String> classPathEntries) {
        StringBuilder result = new StringBuilder();
        for (String classPathEntry : classPathEntries) {
            if (result.length() > 0) {
                result.append(File.pathSeparatorChar);
            }
            result.append(classPathEntry);
        }
        return result.toString();
    }

    private static void addJars(List<String> classPathEntries, File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File jar : files) {
            String jarAbsPath;
            if (!CmdJarsClassLoader.isJarFile(jar) || classPathEntries.contains(jarAbsPath = jar.getAbsolutePath())) continue;
            classPathEntries.add(jarAbsPath);
        }
        for (File subDir : files) {
            if (!subDir.isDirectory()) continue;
            CmdJarsClassLoader.addJars(classPathEntries, subDir);
        }
    }

    private static boolean isJarFile(File file) {
        if (!file.isFile()) {
            return false;
        }
        String path = file.getAbsolutePath();
        if (path.length() < 4) {
            return false;
        }
        if (!path.substring(path.length() - 4).equalsIgnoreCase(".jar")) {
            return false;
        }
        try {
            JarFile jarFile = new JarFile(file);
            jarFile.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

