/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.destinations.impl;

import com.sap.security.destinations.DestinationConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.ServiceTracker;

public class DestinationConfigurationImpl
implements ManagedServiceFactory,
DestinationConfiguration {
    private static final String SERVICE_PID = "destination";
    private static BundleContext context;
    private static DestinationConfigurationImpl instance;
    private static ServiceTracker configAdminTracker;
    private HashMap<String, Properties> destinations = new HashMap();
    private HashMap<String, String> names = new HashMap();

    private DestinationConfigurationImpl() {
    }

    static ServiceRegistration register(BundleContext context) {
        DestinationConfigurationImpl.context = context;
        Properties result = new Properties();
        ((Dictionary)result).put("service.pid", SERVICE_PID);
        configAdminTracker = new ServiceTracker(context, ConfigurationAdmin.class.getName(), null);
        configAdminTracker.open();
        return context.registerService(ManagedServiceFactory.class.getName(), (Object)DestinationConfigurationImpl.getInstance(), (Dictionary)result);
    }

    static synchronized DestinationConfigurationImpl getInstance() {
        if (instance == null) {
            instance = new DestinationConfigurationImpl();
        }
        return instance;
    }

    private Configuration getConfigurationByName(String name, boolean create) throws IOException {
        ConfigurationAdmin admin;
        if (context != null && (admin = (ConfigurationAdmin)configAdminTracker.getService()) != null) {
            try {
                String filter = "(&(service.factoryPid=destination)(Name=" + name + ")" + ")";
                Configuration[] c = admin.listConfigurations(filter);
                if (c != null && c.length > 0) {
                    return c[0];
                }
            }
            catch (InvalidSyntaxException e) {
                e.printStackTrace();
            }
            if (create) {
                return admin.createFactoryConfiguration(SERVICE_PID, null);
            }
        }
        return null;
    }

    private Configuration getConfigurationByPid(String pid) throws IOException {
        ConfigurationAdmin admin;
        if (context != null && (admin = (ConfigurationAdmin)configAdminTracker.getService()) != null) {
            return admin.getConfiguration(pid);
        }
        return null;
    }

    private String name(String pid, Dictionary d) {
        String name = this.names.get(pid);
        if (name == null) {
            name = this.name(d);
        }
        if (name == null) {
            try {
                Configuration c = this.getConfigurationByPid(pid);
                name = this.name(c.getProperties());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        if (name != null) {
            this.names.put(pid, name);
        }
        return name;
    }

    private final String name(Dictionary d) {
        if (d != null) {
            return (String)d.get("Name");
        }
        return null;
    }

    @Override
    public boolean existsDestination(String name) {
        return this.destinations.containsKey(name);
    }

    @Override
    public Properties getDestinationConfiguration(String name) {
        return this.destinations.get(name);
    }

    public List<String> getDestinationNames() {
        Set<String> keys = this.destinations.keySet();
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(keys);
        return result;
    }

    public boolean delete(String name) throws IOException {
        Configuration c = this.getConfigurationByName(name, false);
        if (c != null) {
            c.delete();
            this.destinations.remove(name);
            return true;
        }
        return false;
    }

    public synchronized void deleted(String pid) {
        String name = this.name(pid, null);
        if (name != null) {
            this.destinations.remove(name);
        }
    }

    public String getName() {
        return "Destination Service Configuration";
    }

    public boolean update(String name, Dictionary properties) throws IOException {
        Configuration c = this.getConfigurationByName(name, true);
        if (c != null) {
            properties.put("Name", name);
            c.update(properties);
            this.destinations.put(name, this.convert(properties));
            return true;
        }
        return false;
    }

    public synchronized void updated(String pid, Dictionary properties) {
        String name = this.name(pid, properties);
        if (name != null) {
            this.destinations.put(name, this.convert(properties));
        }
    }

    private final Properties convert(Dictionary properties) {
        Properties p = new Properties();
        Enumeration e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            p.setProperty(key, (String)properties.get(key));
        }
        return p;
    }
}

