/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.destinations.impl;

import com.sap.security.destinations.DestinationConfiguration;
import com.sap.security.destinations.DestinationService;
import com.sap.security.destinations.DestinationServiceLocator;
import java.util.Collection;
import java.util.HashSet;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class DestinationServiceLocatorImpl
extends DestinationServiceLocator {
    private ServiceTracker servicesTracker;
    private DestinationConfiguration configuration;

    DestinationServiceLocatorImpl(BundleContext context, DestinationConfiguration configuration) {
        DestinationServiceLocatorImpl.setLocator(this);
        this.configuration = configuration;
        this.servicesTracker = new ServiceTracker(context, DestinationService.class.getName(), null);
        this.servicesTracker.open();
    }

    public void close() {
        this.servicesTracker.close();
        this.servicesTracker = null;
    }

    @Override
    protected Collection<String> engineGetDestinationTypes() {
        Object[] services = this.servicesTracker.getServices();
        HashSet<String> types = new HashSet<String>();
        int i = 0;
        while (i < services.length) {
            DestinationService service = (DestinationService)services[i];
            String type = service.getType();
            types.add(type);
            ++i;
        }
        return types;
    }

    @Override
    protected DestinationService engineGetService(String type) {
        Object[] services = this.servicesTracker.getServices();
        int i = 0;
        while (i < services.length) {
            DestinationService service = (DestinationService)services[i];
            if (type.equals(service.getType())) {
                service.setConfiguration(this.configuration);
                return service;
            }
            ++i;
        }
        return null;
    }
}

