/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.destinations.impl;

import com.sap.security.destinations.impl.DestinationConfigurationImpl;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class InitialConfiguration
implements ServiceListener {
    private BundleContext context;
    private ServiceTracker configAdminTracker;

    private InitialConfiguration(BundleContext context, ServiceTracker tracker) {
        this.context = context;
        this.configAdminTracker = tracker;
    }

    static void init(BundleContext context) {
        ServiceTracker configAdminTracker = new ServiceTracker(context, ConfigurationAdmin.class.getName(), null);
        InitialConfiguration c = new InitialConfiguration(context, configAdminTracker);
        configAdminTracker.open();
        String filter = "(objectclass=" + ConfigurationAdmin.class.getName() + ")";
        try {
            context.addServiceListener((ServiceListener)c, filter);
            c.configure();
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    private synchronized boolean configure() {
        if (this.configAdminTracker.getService() != null) {
            InitialConfiguration.initialize(this.context);
            this.unregister();
            return true;
        }
        return false;
    }

    private void unregister() {
        this.configAdminTracker.close();
        this.context.removeServiceListener((ServiceListener)this);
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            this.configure();
        }
    }

    private static void initialize(BundleContext context) {
        String configuration = null;
        Enumeration enumeration = context.getBundle().findEntries("/", "config_master", true);
        while (enumeration.hasMoreElements()) {
            URL url = (URL)enumeration.nextElement();
            configuration = url.getPath();
            if (configuration == null) continue;
            if (configuration.endsWith("/")) break;
            configuration = String.valueOf(configuration) + "/";
            break;
        }
        if (configuration != null) {
            enumeration = context.getBundle().findEntries(String.valueOf(configuration) + "service.destinations/destinations", null, true);
            while (enumeration.hasMoreElements()) {
                InitialConfiguration.loadDestinationConfiguration((URL)enumeration.nextElement());
            }
        }
    }

    private static void loadDestinationConfiguration(URL record) {
        try {
            Properties properties = new Properties();
            InputStream in = record.openStream();
            properties.load(in);
            in.close();
            DestinationConfigurationImpl.getInstance().update(properties.getProperty("Name"), properties);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

