/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.api.internal.impl;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import org.apache.log4j.Logger;

public class LandscapeHelper {
    private static final String ECMSERVER_DEFAULT_DESTINATION_NAME = "ecmserver";
    private static final String ECM_SERVER_PORT_REPLACE = "%PORT%";
    private static final String ECM_SERVER_LOCAL_URL = "http://localhost:%PORT%/n/json";
    private static final Logger log = Logger.getLogger(LandscapeHelper.class);

    public static boolean inCloud() {
        return false;
    }

    public static String getDefaultEcmDestinationName() {
        return ECMSERVER_DEFAULT_DESTINATION_NAME;
    }

    public static String getEcmServerUrlLocalhostFallback() {
        return ECM_SERVER_LOCAL_URL.replace(ECM_SERVER_PORT_REPLACE, LandscapeHelper.getCurrentLJSPort());
    }

    private static String getCurrentLJSPort() {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            Set<ObjectName> objs = mbeanServer.queryNames(new ObjectName("Catalina:type=Connector,*"), Query.or(Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")), Query.match(Query.attr("protocol"), Query.value("org.apache.coyote.http11.Http11NioProtocol"))));
            for (ObjectName obj : objs) {
                String port = obj.getKeyProperty("port");
                if (port == null || port.isEmpty()) continue;
                return port;
            }
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)"Could not get port of local LJS", (Throwable)e);
        }
        log.error((Object)"Could not determine the port of local LJS (use default port 8080 that could be the wrong port number)");
        return "8080";
    }
}

