/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.lib.api;

import com.sap.cloud.crypto.lib.api.utils.EncryptUtils;
import com.sap.core.jpaas.security.utils.gson.GsonParserFactory;
import com.sap.engine.lib.xml.util.BASE64Decoder;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import java.io.UnsupportedEncodingException;

public class EncryptedPrivateData {
    private int macKeySize;
    private int encKeySize;
    private String macAlgorithm;
    private String encAlgorithm;
    private String iv;
    private String mac;
    private String encryptedData;

    public String toString() {
        return this.toJSON();
    }

    public String toJSON() {
        return GsonParserFactory.getGsonParserInstance().toJson((Object)this);
    }

    public int getMacKeySize() {
        return this.macKeySize;
    }

    public void setMacKeySize(int macKeySize) {
        this.macKeySize = macKeySize;
    }

    public int getEncKeySize() {
        return this.encKeySize;
    }

    public void setEncKeySize(int encKeySize) {
        this.encKeySize = encKeySize;
    }

    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public void setMacAlgorithm(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
    }

    public String getEncAlgorithm() {
        return this.encAlgorithm;
    }

    public void setEncAlgorithm(String encAlgorithm) {
        this.encAlgorithm = encAlgorithm;
    }

    public byte[] getIv() {
        if (this.iv == null) {
            return null;
        }
        try {
            return BASE64Decoder.decodeN((byte[])this.iv.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            EncryptUtils.LOG.debug("Unknown encoding", (Throwable)e);
            return null;
        }
    }

    public void setIv(byte[] iv) {
        try {
            this.iv = new String(BASE64Encoder.encodeN((byte[])iv), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            EncryptUtils.LOG.debug("Unknown encoding", (Throwable)e);
        }
    }

    public byte[] getMac() {
        if (this.mac == null) {
            return null;
        }
        try {
            return BASE64Decoder.decodeN((byte[])this.mac.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            EncryptUtils.LOG.debug("Unknown encoding", (Throwable)e);
            return null;
        }
    }

    public void setMac(byte[] mac) {
        try {
            this.mac = new String(BASE64Encoder.encodeN((byte[])mac), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            EncryptUtils.LOG.debug("Unknown encoding", (Throwable)e);
        }
    }

    public byte[] getEncryptedData() {
        if (this.encryptedData == null) {
            return null;
        }
        try {
            return BASE64Decoder.decodeN((byte[])this.encryptedData.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            EncryptUtils.LOG.debug("Unknown encoding", (Throwable)e);
            return null;
        }
    }

    public void setEncryptedData(byte[] encryptedData) {
        try {
            this.encryptedData = new String(BASE64Encoder.encodeN((byte[])encryptedData), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            EncryptUtils.LOG.debug("Unknown encoding", (Throwable)e);
        }
    }
}

