/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.lib.api.impl;

import com.sap.cloud.crypto.lib.api.CryptographicException;
import com.sap.cloud.crypto.lib.api.CryptographicService;
import com.sap.cloud.crypto.lib.api.EncryptedPrivateData;
import com.sap.cloud.crypto.lib.api.EncryptionAlgorithm;
import com.sap.cloud.crypto.lib.api.ext.CryptographicServiceExt;
import com.sap.cloud.crypto.lib.api.impl.KeyStoreAsLocalKeystoreService;
import com.sap.cloud.crypto.lib.api.osgi.LocalKeystoreServiceHolder;
import com.sap.cloud.crypto.lib.api.utils.EncryptUtils;
import com.sap.core.jpaas.security.utils.gson.GsonParserFactory;
import com.sap.engine.lib.xml.util.BASE64Decoder;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import com.sap.jpaas.service.securestore.local.keystore.LocalKeystoreService;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyStore;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptographicServiceImpl
implements CryptographicService,
CryptographicServiceExt {
    private static Logger log = LoggerFactory.getLogger(CryptographicService.class);

    @Override
    public byte[] encrypt(byte[] plainData, EncryptionAlgorithm algorithm) throws CryptographicException {
        EncryptedPrivateData encryptedData = this.encryptToPrivateData(plainData, algorithm);
        try {
            return encryptedData.toJSON().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Error: UTF-8 encoding is not supported", (Throwable)e);
            throw new CryptographicException("Error: UTF-8 encoding is not supported", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] encryptedData) throws CryptographicException {
        EncryptedPrivateData encryptedPrivateData = this.getEncryptedPrivateData(encryptedData);
        if (encryptedPrivateData == null) {
            if (log.isDebugEnabled()) {
                log.debug("The received data is not an EncryptedPrivateData object in JSON format");
            }
            throw new CryptographicException("Decryption failed.");
        }
        return this.decryptFromPrivateData(encryptedPrivateData);
    }

    @Override
    public EncryptedPrivateData encryptToPrivateData(byte[] plainData, EncryptionAlgorithm algorithm) throws CryptographicException {
        SecretKeyData keys = this.getSecretKeys(algorithm);
        return this.encrypt(plainData, keys.encryptionKey, keys.signatureKey);
    }

    @Override
    public byte[] decryptFromPrivateData(EncryptedPrivateData encryptedData) throws CryptographicException {
        EncryptionAlgorithm algorithm = this.getEncryptionAlgorithm(encryptedData);
        SecretKeyData keys = this.getSecretKeys(algorithm);
        return this.decrypt(encryptedData, keys.encryptionKey, keys.signatureKey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EncryptionAlgorithm getEncryptionAlgorithm(EncryptedPrivateData encryptedData) throws CryptographicException {
        if (!"AES/CBC/PKCS5Padding".equals(encryptedData.getEncAlgorithm())) throw new CryptographicException("Unknown encryption algorithm used: " + encryptedData.getEncAlgorithm());
        if (encryptedData.getEncKeySize() == 128) {
            return EncryptionAlgorithm.AES_128;
        }
        if (encryptedData.getEncKeySize() != 256) throw new CryptographicException("Unknown key size: " + encryptedData.getEncKeySize());
        return EncryptionAlgorithm.AES_256;
    }

    @Override
    public byte[] decryptFromPrivateData(EncryptedPrivateData encryptedData, KeyStore decryptionKeyStore, char[] keystorePassword) throws CryptographicException {
        EncryptionAlgorithm algorithm = this.getEncryptionAlgorithm(encryptedData);
        SecretKeyData keys = this.getSecretKeys(algorithm, new KeyStoreAsLocalKeystoreService(decryptionKeyStore, keystorePassword));
        return this.decrypt(encryptedData, keys.encryptionKey, keys.signatureKey);
    }

    @Override
    public EncryptedPrivateData getEncryptedPrivateData(byte[] data) {
        return EncryptUtils.getEncryptedPrivateData(data);
    }

    @Override
    public void backupLocalKeystoreService(KeyStore decryptionKeyStore, char[] keystorePassword) throws CryptographicException {
        LocalKeystoreService localKeystore = LocalKeystoreServiceHolder.getLocalKeystoreService();
        try {
            Key key = localKeystore.getKey("application_enckey_256");
            decryptionKeyStore.setKeyEntry("application_enckey_256", key, keystorePassword, null);
            key = localKeystore.getKey("application_enckey_128");
            decryptionKeyStore.setKeyEntry("application_enckey_128", key, keystorePassword, null);
            key = localKeystore.getKey("application_signkey_256");
            decryptionKeyStore.setKeyEntry("application_signkey_256", key, keystorePassword, null);
        }
        catch (Exception e) {
            log.error("Failed to backup the LocalKeystoreService", (Throwable)e);
            throw new CryptographicException("Failed to backup the LocalKeystoreService", e);
        }
    }

    @Override
    public EncryptedPrivateData encryptToPrivateData(byte[] plainData, EncryptionAlgorithm algorithm, KeyStore decryptionKeyStore, char[] decryptionKeyStorePassword) throws CryptographicException {
        SecretKeyData keys = this.getSecretKeys(algorithm, new KeyStoreAsLocalKeystoreService(decryptionKeyStore, decryptionKeyStorePassword));
        return this.encrypt(plainData, keys.encryptionKey, keys.signatureKey);
    }

    private EncryptedPrivateData encrypt(byte[] plainData, SecretKey encryptionKey, SecretKey signatureKey) throws CryptographicException {
        try {
            EncryptedPrivateData encryptedData = EncryptUtils.encryptPrivateData(plainData, encryptionKey, signatureKey);
            log.debug("Successfully encrypted {}", (Object)encryptedData);
            return encryptedData;
        }
        catch (Exception e) {
            log.debug("Encryption failed", (Throwable)e);
            throw new CryptographicException("Encryption failed", e);
        }
    }

    private byte[] decrypt(EncryptedPrivateData encryptedData, SecretKey decryptionKey, SecretKey verificationKey) throws CryptographicException {
        try {
            byte[] decryptedData = EncryptUtils.decryptPrivateData(encryptedData, decryptionKey, verificationKey);
            log.debug("Successfully decrypted {} ", (Object)encryptedData);
            return decryptedData;
        }
        catch (Exception e) {
            log.debug("Decryption failed", (Throwable)e);
            throw new CryptographicException("Decryption failed", e);
        }
    }

    private SecretKeyData getSecretKeys(EncryptionAlgorithm algorithm) throws CryptographicException {
        return this.getSecretKeys(algorithm, LocalKeystoreServiceHolder.getLocalKeystoreService());
    }

    private SecretKeyData getSecretKeys(EncryptionAlgorithm algorithm, LocalKeystoreService keystoreService) throws CryptographicException {
        SecretKeyData data = new SecretKeyData();
        try {
            if (algorithm == EncryptionAlgorithm.AES_256) {
                data.encryptionKey = (SecretKey)keystoreService.getKey("application_enckey_256");
            } else if (algorithm == EncryptionAlgorithm.AES_128) {
                data.encryptionKey = (SecretKey)keystoreService.getKey("application_enckey_128");
            } else {
                throw new CryptographicException("Unknown encryption algorithm: " + (Object)((Object)algorithm));
            }
            data.signatureKey = (SecretKey)keystoreService.getKey("application_signkey_256");
        }
        catch (Exception e) {
            throw new CryptographicException("Failed to retrieve keys for signature and encryption from the local keystore", e);
        }
        if (data.encryptionKey == null) {
            if (log.isWarnEnabled()) {
                log.warn("Key with alias application_enckey_128 not available in the local keystore");
            }
            throw new CryptographicException("Failed to retrieve key encryption from the local keystore");
        }
        if (data.signatureKey == null) {
            if (log.isWarnEnabled()) {
                log.warn("Key with alias application_signkey_256 not available in the local keystore");
            }
            throw new CryptographicException("Failed to retrieve key for signature from the local keystore");
        }
        return data;
    }

    private SecretKeyData getDrTransportKeys(KeyStore keystore, char[] password) throws CryptographicException {
        SecretKeyData data = new SecretKeyData();
        try {
            data.encryptionKey = (SecretKey)keystore.getKey("dr.transport.key", password);
            data.signatureKey = (SecretKey)keystore.getKey("dr.signature.key", password);
        }
        catch (Exception e) {
            throw new CryptographicException("Failed to retrieve dr transport keys for signature and encryption from the keystore", e);
        }
        if (data.encryptionKey == null) {
            if (log.isWarnEnabled()) {
                log.warn("Key with alias dr.transport.key not available in the keystore");
            }
            throw new CryptographicException("Failed to retrieve encryption key from the keystore");
        }
        if (data.signatureKey == null) {
            if (log.isWarnEnabled()) {
                log.warn("Key with alias dr.signature.key not available in the keystore");
            }
            throw new CryptographicException("Failed to retrieve signature key from the keystore");
        }
        return data;
    }

    private SecretKeyData getDrMasterKeys(EncryptionAlgorithm algorithm, KeyStore keystore, char[] password) throws CryptographicException {
        SecretKeyData data = new SecretKeyData();
        try {
            if (algorithm == EncryptionAlgorithm.AES_256) {
                data.encryptionKey = (SecretKey)keystore.getKey("application_enckey_256", password);
            } else if (algorithm == EncryptionAlgorithm.AES_128) {
                data.encryptionKey = (SecretKey)keystore.getKey("application_enckey_128", password);
            } else {
                throw new CryptographicException("Unknown encryption algorithm: " + (Object)((Object)algorithm));
            }
            data.signatureKey = (SecretKey)keystore.getKey("application_signkey_256", password);
        }
        catch (Exception e) {
            throw new CryptographicException("Failed to retrieve keys for signature and encryption from the keystore", e);
        }
        if (data.encryptionKey == null) {
            if (log.isWarnEnabled()) {
                log.warn("Key with alias application_enckey_128 not available in the keystore");
            }
            throw new CryptographicException("Failed to retrieve key encryption from the keystore");
        }
        if (data.signatureKey == null) {
            if (log.isWarnEnabled()) {
                log.warn("Key with alias application_signkey_256 not available in the keystore");
            }
            throw new CryptographicException("Failed to retrieve key for signature from the keystore");
        }
        return data;
    }

    @Override
    public byte[] encryptToPrivateDataDr(byte[] plainData, KeyStore decryptionKeyStore, char[] password) throws CryptographicException, UnsupportedEncodingException {
        byte[] base64DecodedData = BASE64Decoder.decode((byte[])plainData);
        EncryptedPrivateData encryptedPrivateData = this.getEncryptedPrivateData(base64DecodedData);
        SecretKeyData drTransportKeys = this.getDrTransportKeys(decryptionKeyStore, password);
        SecretKeyData drMasterKeys = this.getDrMasterKeys(this.getEncryptionAlgorithm(encryptedPrivateData), decryptionKeyStore, password);
        byte[] decryptedDataMaster = this.decrypt(encryptedPrivateData, drMasterKeys.encryptionKey, drMasterKeys.signatureKey);
        EncryptedPrivateData resultData = this.encrypt(decryptedDataMaster, drTransportKeys.encryptionKey, drTransportKeys.signatureKey);
        return BASE64Encoder.encode((byte[])GsonParserFactory.getGsonParserInstance().toJson((Object)resultData).getBytes());
    }

    @Override
    public byte[] decryptFromPrivateDataDr(byte[] encryptedData, KeyStore decryptionKeyStore, char[] password) throws CryptographicException {
        EncryptedPrivateData encryptedPrivateData = this.getEncryptedPrivateData(BASE64Decoder.decode((byte[])encryptedData));
        SecretKeyData drTransportKeys = this.getDrTransportKeys(decryptionKeyStore, password);
        SecretKeyData drMasterKeys = this.getDrMasterKeys(this.getEncryptionAlgorithm(encryptedPrivateData), decryptionKeyStore, password);
        byte[] decryptedData = this.decrypt(encryptedPrivateData, drTransportKeys.encryptionKey, drTransportKeys.signatureKey);
        EncryptedPrivateData resultData = this.encrypt(decryptedData, drMasterKeys.encryptionKey, drMasterKeys.signatureKey);
        return BASE64Encoder.encode((byte[])GsonParserFactory.getGsonParserInstance().toJson((Object)resultData).getBytes());
    }

    public String toString() {
        return "CryprographicService#" + this.hashCode();
    }

    private class SecretKeyData {
        SecretKey encryptionKey;
        SecretKey signatureKey;

        private SecretKeyData() {
        }
    }
}

