/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.lib.api.impl;

import com.sap.jpaas.service.securestore.local.keystore.LocalKeystoreService;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;

public class KeyStoreAsLocalKeystoreService
implements LocalKeystoreService {
    private final KeyStore wrappedKeyStore;
    private final char[] keyStorePassword;

    public KeyStoreAsLocalKeystoreService(KeyStore wrappedKeyStore, char[] keyStorePassword) {
        this.wrappedKeyStore = wrappedKeyStore;
        this.keyStorePassword = keyStorePassword;
    }

    public Key getKey(String alias) throws GeneralSecurityException, IOException {
        return this.wrappedKeyStore.getKey(alias, this.keyStorePassword);
    }

    public Certificate getCertificate(String alias) throws GeneralSecurityException, IOException {
        return this.wrappedKeyStore.getCertificate(alias);
    }

    public KeyStore.Entry getEntry(String s, KeyStore.ProtectionParameter protectionParameter) throws GeneralSecurityException, IOException {
        return this.wrappedKeyStore.getEntry(s, protectionParameter);
    }

    public KeyStore.Entry getEntry(String s) throws GeneralSecurityException, IOException {
        return this.wrappedKeyStore.getEntry(s, new KeyStore.PasswordProtection(this.keyStorePassword));
    }
}

