/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.lib.api.osgi;

import com.sap.cloud.crypto.lib.api.CryptographicService;
import com.sap.cloud.crypto.lib.api.ext.CryptographicServiceExt;
import com.sap.cloud.crypto.lib.api.impl.CryptographicServiceImpl;
import com.sap.jpaas.service.securestore.local.keystore.LocalKeystoreService;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer<LocalKeystoreService, LocalKeystoreService> {
    private ServiceTracker<LocalKeystoreService, LocalKeystoreService> tracker;
    private CryptographicService service;
    private ServiceRegistration<CryptographicService> serviceRegistration;
    private ServiceRegistration<CryptographicServiceExt> serviceExtRegistration;
    private BundleContext bc;
    private static Logger LOG = LoggerFactory.getLogger(CryptographicService.class);
    private static LocalKeystoreService localKeystoreService;

    public void start(BundleContext bc) throws Exception {
        LOG.debug("Cryptographic library bundle starting ...");
        this.service = new CryptographicServiceImpl();
        this.serviceRegistration = bc.registerService(CryptographicService.class, (Object)this.service, new Hashtable());
        LOG.debug("Cryptographic service registered ");
        this.serviceExtRegistration = bc.registerService(CryptographicServiceExt.class, (Object)((CryptographicServiceExt)this.service), new Hashtable());
        LOG.debug("Extended cryptographic service registered ");
        this.bc = bc;
        this.tracker = new ServiceTracker(bc, LocalKeystoreService.class, (ServiceTrackerCustomizer)this);
        this.tracker.open();
        LOG.debug("LocalKeystoreService tracker registered");
        LOG.debug("Cryptographic library bundle started");
    }

    public void stop(BundleContext bc) throws Exception {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
        if (this.serviceExtRegistration != null) {
            this.serviceExtRegistration.unregister();
        }
        this.tracker.close();
        this.bc = null;
        this.tracker = null;
        this.service = null;
        LOG.debug("Cryptographic library bundle stopped");
    }

    public static LocalKeystoreService getLocalKeystoreService() {
        return localKeystoreService;
    }

    public LocalKeystoreService addingService(ServiceReference<LocalKeystoreService> ref) {
        localKeystoreService = (LocalKeystoreService)this.bc.getService(ref);
        LOG.debug("LocalKeystoreService added");
        return localKeystoreService;
    }

    public void modifiedService(ServiceReference<LocalKeystoreService> localKeystoreServiceServiceReference, LocalKeystoreService localKeystoreService) {
    }

    public void removedService(ServiceReference<LocalKeystoreService> ref, LocalKeystoreService service) {
        LOG.debug("LocalKeystoreService removed");
        if (this.bc != null) {
            this.bc.ungetService(ref);
        }
        localKeystoreService = null;
    }
}

