/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.crypto.lib.api.utils;

import com.sap.cloud.crypto.lib.api.EncryptedPrivateData;
import com.sap.core.jpaas.security.utils.gson.GsonParserFactory;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptUtils {
    public static final Logger LOG = LoggerFactory.getLogger(EncryptUtils.class);
    private static final int BITS_IN_BYTE = 8;

    public static EncryptedPrivateData encryptPrivateData(byte[] privateData, SecretKey encryptionKey, SecretKey macKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, IOException {
        EncryptedPrivateData toRet = new EncryptedPrivateData();
        toRet.setMacAlgorithm("HMACSHA256");
        toRet.setEncAlgorithm("AES/CBC/PKCS5Padding");
        if (encryptionKey.getEncoded() != null) {
            toRet.setEncKeySize(encryptionKey.getEncoded().length * 8);
        }
        if (macKey.getEncoded() != null) {
            toRet.setMacKeySize(macKey.getEncoded().length * 8);
        }
        Cipher enc = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecureRandom secRandom = SecureRandom.getInstance("SHA1PRNG");
        Mac mac = Mac.getInstance("HMACSHA256");
        enc.init(1, (Key)encryptionKey, secRandom);
        toRet.setEncryptedData(enc.doFinal(privateData));
        toRet.setIv(enc.getIV());
        mac.init(macKey);
        mac.update(toRet.getIv());
        toRet.setMac(mac.doFinal(toRet.getEncryptedData()));
        return toRet;
    }

    public static EncryptedPrivateData getEncryptedPrivateData(byte[] encryptedData) {
        EncryptedPrivateData encryptedPrivateData;
        block18: {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            try {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("getEncryptedPrivateData(): ");
                                }
                                if ("AES/CBC/PKCS5Padding".equalsIgnoreCase((encryptedPrivateData = (EncryptedPrivateData)GsonParserFactory.getGsonParserInstance().fromJson(new String(encryptedData, "UTF8"), EncryptedPrivateData.class)).getEncAlgorithm())) break block14;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Encryption algorithm {} is not supported", (Object)encryptedPrivateData.getEncAlgorithm());
                                }
                                return null;
                            }
                            catch (Exception e) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("getEncryptedPrivateData(): ", (Throwable)e);
                                }
                                return null;
                            }
                        }
                        if ("HMACSHA256".equalsIgnoreCase(encryptedPrivateData.getMacAlgorithm())) break block15;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Signature algorithm {} is not supported", (Object)encryptedPrivateData.getMacAlgorithm());
                        }
                        return null;
                    }
                    if (encryptedPrivateData.getIv() != null) break block16;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("IV is null");
                    }
                    return null;
                }
                if (encryptedPrivateData.getMac() != null) break block17;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("MAC is null");
                }
                return null;
            }
            if (encryptedPrivateData.getEncryptedData() != null) break block18;
            if (LOG.isDebugEnabled()) {
                LOG.debug("encryptedData is null");
            }
            return null;
        }
        return encryptedPrivateData;
    }

    public static byte[] decryptPrivateData(EncryptedPrivateData encryptedData, SecretKey decryptionKey, SecretKey macKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, IOException, InvalidAlgorithmParameterException, BadPaddingException {
        if (decryptionKey.getEncoded() != null && encryptedData.getEncKeySize() != decryptionKey.getEncoded().length * 8) {
            throw new InvalidKeyException("Data was encrypted with key size:" + encryptedData.getEncKeySize() + " found key size: " + decryptionKey.getEncoded().length * 8);
        }
        if (macKey.getEncoded() != null && encryptedData.getMacKeySize() != macKey.getEncoded().length * 8) {
            throw new InvalidKeyException("Data was signed with key size:" + encryptedData.getMacKeySize() + " found key size: " + macKey.getEncoded().length * 8);
        }
        if (!"AES/CBC/PKCS5Padding".equalsIgnoreCase(encryptedData.getEncAlgorithm())) {
            throw new InvalidKeyException("Encryption algorithm " + encryptedData.getEncAlgorithm() + " is not supported");
        }
        if (!"HMACSHA256".equalsIgnoreCase(encryptedData.getMacAlgorithm())) {
            throw new InvalidKeyException("Signature algorithm " + encryptedData.getMacAlgorithm() + " is not supported");
        }
        Cipher dec = Cipher.getInstance("AES/CBC/PKCS5Padding");
        Mac mac = Mac.getInstance("HMACSHA256");
        if (encryptedData.getMac() == null || encryptedData.getMac().length != mac.getMacLength()) {
            throw new IllegalBlockSizeException("Wrong size MAC:" + Arrays.toString(encryptedData.getMac()));
        }
        if (encryptedData.getIv() == null || encryptedData.getIv().length != dec.getBlockSize()) {
            throw new IllegalBlockSizeException("Wrong size IV:" + Arrays.toString(encryptedData.getIv()));
        }
        mac.init(macKey);
        mac.update(encryptedData.getIv());
        byte[] hmacCalculated = mac.doFinal(encryptedData.getEncryptedData());
        if (!Arrays.equals(encryptedData.getMac(), hmacCalculated)) {
            throw new IOException("Different message authentication code \nreceived:\n\t" + Arrays.toString(encryptedData.getMac()) + "\ncalculated:\n\t" + Arrays.toString(hmacCalculated));
        }
        IvParameterSpec parameterSpec = new IvParameterSpec(encryptedData.getIv());
        dec.init(2, (Key)decryptionKey, parameterSpec);
        byte[] ret = dec.doFinal(encryptedData.getEncryptedData());
        return ret;
    }
}

