/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.commands;

import com.beust.jcommander.Parameter;
import com.sap.core.deploy.client.cmd.commands.DeployApplicationCommand;
import com.sap.core.deploy.client.cmd.converters.VmSizeParameterConverter;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.client.cmd.validators.CompressionTypeValidator;
import com.sap.core.deploy.client.cmd.validators.SecureStringForXMLParamValidator;
import com.sap.core.deploy.client.cmd.validators.TomcatConnectorParamsValidator;
import com.sap.core.deploy.commons.rest.entity.enumerations.VmSize;
import com.sap.jpaas.infrastructure.console.converter.URLParameterConverter;
import com.sap.jpaas.infrastructure.console.help.ordering.Group;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import com.sap.jpaas.infrastructure.console.validator.Log4jLevelValidator;
import com.sap.jpaas.infrastructure.console.validator.SACValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractCommonDeployParametersHolder
extends DeployApplicationCommand {
    @Parameter(names={"-c", "-component", "--component"}, description="Component", validateWith=SACValidator.class, hidden=true)
    String component = "web";
    @Group(group="command-specific parameters")
    @Parameter(names={"-s", "-source", "--source"}, description="A comma-separated list of file locations, pointing to WAR files, or folders containing them", converter=URLParameterConverter.class)
    String source;
    @Group(group="command-specific parameters")
    @Parameter(names={"-x", "-url", "--url-prefix"}, description="URL prefix of the component", hidden=true)
    String shortUrl;
    @Group(group="command-specific parameters")
    @Parameter(names={"-d", "--url-domains"}, description="Domain names suffixes of an application URL", hidden=true)
    String appDomains;
    @Group(group="command-specific parameters")
    @Parameter(names={"-e", "-services", "--services"}, description="Comma separated list with services", hidden=true)
    String services;
    @Group(group="command-specific parameters")
    @Parameter(names={"-r", "--mirror-repository"}, description="Mirrors repository", hidden=true)
    boolean mirror;
    @Group(group="command-specific parameters")
    @Parameter(names={"-configuration_folder", "--configuration-folder"}, description="Configuration folder to upload", hidden=true)
    String configFolder;
    @Group(group="command-specific parameters")
    @Parameter(names={"-V", "--vm-arguments"}, description="Java Virtual Machine arguments")
    String vmArguments;
    @Group(group="command-specific parameters")
    @Parameter(names={"-j", "--java-version"}, description="Java Virtual Machine major version number. Use either 6 or 7 (recommended)")
    String jvmVersion;
    @Group(group="command-specific parameters")
    @Parameter(names={"-S", "--service-instances-configuration"}, description="Configuration file, containing creation properties for service instances, consumed by the application", hidden=true)
    String serviceInstancesCfg;
    @Group(group="command-specific parameters")
    @Parameter(names={"-z", "--size"}, description="Compute unit size. Acceptable values: lite, pro, prem, prem-plus. Default: the smallest size from the subaccount quotas", converter=VmSizeParameterConverter.class)
    VmSize vmSize;
    @Group(group="command-specific parameters")
    @Parameter(names={"--runtime-version"}, description="Version of SAP Cloud Platform application runtime")
    String runtimeVersion;
    @Group(group="command-specific parameters")
    @Parameter(names={"--connections"}, description="Number of connections used to deploy the content: 1 to 6; default = 2")
    String uploadConnections;
    @Group(group="tomcat connector attributes", rank=1)
    @Parameter(names={"--compression"}, description="Enables or disables gzip response compression. Acceptable values: 'on', 'off', 'force' or an integer. Default: 'off'", validateWith=CompressionTypeValidator.class)
    String compression;
    @Group(group="tomcat connector attributes", rank=3)
    @Parameter(names={"--compressible-mime-type"}, description="Comma-separated list of MIME types for which compression will be used. Default: 'text/html, text/xml, text/plain'", validateWith=CompressionTypeValidator.class)
    String compressibleMimeTypes;
    @Group(group="tomcat connector attributes", rank=2)
    @Parameter(names={"--compression-min-size"}, description="Sets compression threshold in bytes. Only responses bigger than this value get compressed. Default: 2048", validateWith=CompressionTypeValidator.class)
    String compressionMinSize;
    @Group(group="tomcat connector attributes", rank=4)
    @Parameter(names={"--uri-encoding"}, description="Specifies the character encoding used to decode the URI bytes. Acceptable values: all encodings supported by JRE version 6 or higher. Default: ISO-8859-1", validateWith=SecureStringForXMLParamValidator.class)
    String uriEncoding;
    @Group(group="tomcat connector attributes", rank=5)
    @Parameter(names={"--max-threads"}, description="Specifies the maximum number of simultaneous requests that can be handled. Default: 200", validateWith=TomcatConnectorParamsValidator.class)
    String maxThreads;
    @Group(group="tomcat connector attributes", rank=6)
    @Parameter(names={"--connection-timeout"}, description="Defines the number of milliseconds to wait for the request URI line to be presented after accepting a connection. Default: 20000", validateWith=TomcatConnectorParamsValidator.class)
    String connectionTimeout;
    @Group(group="command-specific parameters")
    @Parameter(names={"--file-storage-mode"}, description="Experimental! File storage mode. Possible values: persistent, local", hidden=true)
    String permStorageMode = "none";
    @Group(group="command-specific parameters")
    @Parameter(names={"--file-storage-size"}, description="Experimental! Size of the file storage in GiBs. Default value is 10 GiBs", hidden=true)
    int permStorageSize = 10;
    @Group(group="command-specific parameters")
    @Parameter(names={"--file-storage-local-path"}, description="Experimental! The path where file storage will be mounted to, relative to runtime folder", hidden=true)
    String permStorageLocalPath = "permanent_storage";
    @Group(group="command-specific parameters")
    @Parameter(names={"-v", "-iuVersion", "--installable-unit-version"}, description="Installable unit version", hidden=true)
    String iuVersion = "0.0.0";
    @Group(group="command-specific parameters")
    @Parameter(names={"-i", "-iu", "--installable-unit"}, description="Installable unit", hidden=true)
    String installableUnits;
    @Group(group="command-specific parameters")
    @Parameter(names={"--runtime"}, description="Name of SAP Cloud Platform application runtime")
    String runtimeId;
    @Group(group="command-specific parameters")
    @Parameter(names={"-l", "-severity", "--severity"}, description="Severity of the server process root logger", validateWith=Log4jLevelValidator.class, hidden=true)
    String severity;
    @Parameter(names={"--ev"}, description="Sets one environment variable; can be used multiple times in one execution.\nExample: --ev key=value --ev \"key2=value2\". Keys cannot contain spaces.")
    Set<String> environmentVariables;

    public void dumpParameters(String message) {
        List<Object> argsList = this.getArgsList();
        DumpHelper.dumpOperationList(this.user, message, argsList.toArray());
    }

    protected Map<String, String> getValidatedAndConvertedEnvVariablesToMetadataMap() {
        Map<String, String> metadata = CheckHelper.validateAndConvertEnvironmentVariablesToMetadataMap(this.environmentVariables);
        CheckHelper.dumpWarningMessageIfNeeded(metadata);
        return metadata;
    }

    protected List<Object> getArgsList() {
        ArrayList<Object> argsList = new ArrayList<Object>();
        if (!this.component.equalsIgnoreCase("web")) {
            Collections.addAll(argsList, "component", this.component);
        }
        Collections.addAll(argsList, "application", this.application, "subaccount", this.account, "source", this.source, "IU", this.getInstallableUnits());
        if (this.vmSize != null) {
            Collections.addAll(argsList, "compute unit size", this.vmSize.optionName());
        }
        if (this.permStorageMode != null && !this.permStorageMode.equals("none")) {
            Collections.addAll(argsList, "file storage mode", this.permStorageMode, "file storage size (GB)", this.permStorageSize, "file storage path", this.permStorageLocalPath);
        }
        Collections.addAll(argsList, "runtime version", this.runtimeVersion, "runtime", this.getRuntimeId(), "component URL", this.shortUrl, "services", this.services, "domain suffixes", this.appDomains, "vm arguments", this.vmArguments, "JVM version", this.jvmVersion, "severity", this.getSeverity(), "host", this.host, "configuration", this.configFolder, "connections", this.uploadConnections, "compression", this.compression, "compressible-mime-type", this.compressibleMimeTypes, "compression-min-size", this.compressionMinSize, "URI encoding", this.uriEncoding, "max-threads", this.maxThreads, "connection-timeout", this.connectionTimeout);
        if (!this.iuVersion.equals("0.0.0")) {
            Collections.addAll(argsList, "IU version", this.iuVersion);
        }
        this.addSpecificArguments(argsList);
        return argsList;
    }

    protected abstract String getInstallableUnits();

    protected abstract List<Object> addSpecificArguments(List<Object> var1);

    protected abstract String getRuntimeId();

    protected abstract String getSeverity();
}

