/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.sap.core.deploy.client.cmd.commands.DeployRemoteCommand;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.jpaas.infrastructure.console.validator.SACValidator;

public abstract class DeployApplicationCommand
extends DeployRemoteCommand {
    @Parameter(names={"-b", "-application", "--application"}, description="Name of the application you want to manage, configure, or deploy")
    String application;
    @Parameter(names={"-appliance", "--appliance"}, description="Appliance", hidden=true)
    String deprecated_appliance;

    @Override
    public void init() {
        super.init();
        this.checkApplicationParameter();
    }

    protected void checkApplicationParameter() {
        CheckHelper.validateApplianceApplicationArguments(this.deprecated_appliance, this.application);
        if (this.deprecated_appliance != null) {
            this.application = this.deprecated_appliance;
        }
        if (!CheckHelper.isValueSpecified(this.application)) {
            throw new ParameterException("Parameter --application is not specified.");
        }
        String originalValue = this.application;
        this.application = this.application.toLowerCase();
        this.checkApplicationParameterValue();
        if (!originalValue.equals(this.application)) {
            DeployDumpHelper.dumpWarningMessage("Application names can contain only small letters, so " + originalValue + " was saved as " + this.application);
        }
    }

    protected void checkApplicationParameterValue() {
        SACValidator validator = new SACValidator();
        validator.validate("--application", this.application);
    }
}

