/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.deploy.client.cmd.Constants;
import com.sap.core.deploy.client.cmd.commands.AbstractCommonDeployParametersHolder;
import com.sap.core.deploy.client.cmd.helpers.DeployHelper;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.core.deploy.client.cmd.validators.DeployTimeoutParamValidator;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.help.ordering.Group;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Parameters(commandDescription="Deploys WARs or installable units")
public class DeployCommand
extends AbstractCommonDeployParametersHolder {
    @Group(group="command-specific parameters")
    @Parameter(names={"-m", "-min", "--minimum-processes"}, description="Minimum number of server processes")
    int min = 1;
    @Group(group="command-specific parameters")
    @Parameter(names={"-M", "-max", "--maximum-processes"}, description="Maximum number of server processes")
    int max = 1;
    @Parameter(names={"-ds", "--delta"}, description="Deploys only the changes between the provided source and the deployed content. New content will be added; missing content will be deleted. Recommended for development use to speed up the deployment.")
    boolean delta;
    @Group(group="command-specific parameters")
    @Parameter(names={"-o", "--deploy-timeout"}, description="Defines the time limit in seconds for the deploy. Default: 21600 (6 hours)", validateWith=DeployTimeoutParamValidator.class)
    long deployTimeout = Constants.PARAM_DEPLOY_TIMEOUT_DEFAULT_VALUE;

    @Override
    public void run() throws CommandException {
        this.dumpParameters("Requesting deployment for:");
        Map<String, String> metadata = this.getValidatedAndConvertedEnvVariablesToMetadataMap();
        if (!CheckHelper.checkArgSpecified("-s", "--source", this.source, true)) {
            throw new HelpException("Source not specified", 130);
        }
        DeployHelper helper = new DeployHelper(this.account, this);
        helper.deploy(this.application, this.component, this.source, this.installableUnits, this.iuVersion, this.min, this.max, this.shortUrl, this.appDomains, this.services, this.mirror, this.severity, this.configFolder, this.vmArguments, this.jvmVersion, this.serviceInstancesCfg, this.vmSize, this.runtimeId, this.runtimeVersion, this.uploadConnections, this.compression, this.compressibleMimeTypes, this.compressionMinSize, this.permStorageMode, this.permStorageSize, this.permStorageLocalPath, this.uriEncoding, this.maxThreads, this.connectionTimeout, this.deployTimeout, this.delta, metadata);
    }

    @Override
    public String getName() {
        return "deploy";
    }

    @Override
    public List<Object> addSpecificArguments(List<Object> argsList) {
        if (this.delta) {
            Collections.addAll(argsList, "delta deployment", "yes");
        }
        Collections.addAll(argsList, "elasticity data", "[" + this.min + " .. " + this.max + "]");
        DeployDumpHelper.addEnvVariablesToArgsList(argsList, this.environmentVariables);
        Collections.addAll(argsList, "deploy-timeout", this.deployTimeout + " seconds");
        return argsList;
    }

    @Override
    protected String getRuntimeId() {
        return this.runtimeId;
    }

    @Override
    protected String getSeverity() {
        return this.severity;
    }

    @Override
    protected String getInstallableUnits() {
        return this.installableUnits;
    }
}

