/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.deploy.client.cmd.commands.DeployProcessIdCommand;
import com.sap.core.deploy.client.cmd.helpers.DisableCommandHelper;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;

@Parameters(commandDescription="Disable an application or application process for new connection requests, all active connections will be still handled")
public class DisableCommand
extends DeployProcessIdCommand {
    @Parameter(names={"-c", "-component", "--component"}, description="Component", hidden=true)
    String component = "web";
    @Parameter(names={"-t", "-tenant", "--tenant"}, description="Tenant-isolated application process for the given tenant", hidden=true)
    String tenant;

    @Override
    public String getName() {
        return "disable";
    }

    @Override
    public void run() throws CommandException {
        if (this.applicationProcessId != null) {
            CheckHelper.validateApplicationProcessId(this.applicationProcessId);
            DisableCommandHelper disableHelper = new DisableCommandHelper(this);
            disableHelper.disable(this.applicationProcessId);
        } else {
            CheckHelper.validateApplicationAndComponentArguments(this.application, this.component);
            DisableCommandHelper disableHelper = new DisableCommandHelper(this.account, this);
            disableHelper.disable(this.application, this.component, this.tenant);
        }
    }
}

