/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.deploy.client.ComponentAttributesResult;
import com.sap.core.deploy.client.DeployClient;
import com.sap.core.deploy.client.IConfigurationManager;
import com.sap.core.deploy.client.cmd.commands.DeployApplicationCommand;
import com.sap.core.deploy.client.cmd.timeout.SynchronousProgressMonitor;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import com.sap.jpaas.infrastructure.console.validator.SACValidator;
import java.util.ArrayList;
import java.util.Collections;

@Parameters(commandDescription="Display deployment application properties")
public class DisplayApplicationPropertiesCommand
extends DeployApplicationCommand {
    @Parameter(names={"-c", "--component"}, description="Component", validateWith=SACValidator.class, hidden=true)
    String component = "web";

    @Override
    public String getName() {
        return "display-application-properties";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() throws CommandException {
        if (this.component == null || this.component.trim().length() == 0) {
            this.component = "web";
        }
        if (!CheckHelper.checkArgsListComponents(this.account, this.application, this.host)) throw new HelpException("Invalid parameters", 10);
        ArrayList argsList = new ArrayList();
        if (!this.component.equalsIgnoreCase("web")) {
            Collections.addAll(argsList, "component", this.component);
        }
        Collections.addAll(argsList, "application", this.application, "subaccount", this.account);
        DumpHelper.dumpOperationList(this.user, "Requesting application properties for:", argsList.toArray());
        this.askForPasswordAndInitHttpClient();
        ComponentAttributesResult result = null;
        IConfigurationManager cfgManager = DeployClient.getConfigurationManager(this.httpClient, this.account, "CMD Tools", null);
        SynchronousProgressMonitor monitor = new SynchronousProgressMonitor("Requesting application properties...");
        try {
            monitor.startMonitor();
            result = cfgManager.getConfiguration(this.application, this.component, this.host);
        }
        catch (Exception e) {
            throw new CommandException("Request for application properties finished with error", e, 166);
        }
        finally {
            monitor.stopMonitor();
        }
        if (result.getCode() == 0) {
            System.out.println();
            DeployDumpHelper.dumpWithDateNewLine("Request for application properties finished successfully");
            if (result.getEnvironmentVariables() != null) {
                Collections.sort(result.getEnvironmentVariables());
            }
            DumpHelper.dumpOperationList("Application properties:", new Object[]{"--runtime".substring(2), result.getRuntimeId(), "--runtime-version".substring(2), result.getRuntimeVersion(), "--minimum-processes".substring(2), result.getMinVmCount(), "--maximum-processes".substring(2), result.getMaxVmCount(), "--vm-arguments".substring(2), result.getVmArgs(), "--size".substring(2), result.getVmSize(), "--java-version".substring(2), result.getJavaVersion(), "environment variables", result.getEnvironmentVariables() != null ? result.getEnvironmentVariables() : null, "--compression".substring(2), null, "--compressible-mime-type".substring(2), null, "--compression-min-size".substring(2), null, "--uri-encoding".substring(2), null, "--max-threads".substring(2), null, "--connection-timeout".substring(2), null});
            if (!this.resultContainsTomcatAttributes(result)) return;
            DumpHelper.dumpOperationList("Tomcat connector attributes", new Object[]{"--runtime".substring(2), null, "--runtime-version".substring(2), null, "--minimum-processes".substring(2), null, "--maximum-processes".substring(2), null, "--vm-arguments".substring(2), null, "--size".substring(2), null, "--java-version".substring(2), null, "--compression".substring(2), result.getCompressionEnabled(), "--compressible-mime-type".substring(2), result.getCompressionMimeType(), "--compression-min-size".substring(2), result.getCompressionMinSize() != null ? result.getCompressionMinSize() + " " + "bytes" : null, "--uri-encoding".substring(2), result.getUriEncoding(), "--max-threads".substring(2), result.getMaxThreads(), "--connection-timeout".substring(2), result.getConnectionTimeout() != null ? result.getConnectionTimeout() + " " + "ms" : null});
            return;
        } else {
            System.out.println();
            DeployDumpHelper.dumpWithDateNewLine("Request for application properties finished with error");
            System.out.println(result.getMessage());
            throw new CommandException(result.getMessage(), 210);
        }
    }

    private boolean resultContainsTomcatAttributes(ComponentAttributesResult result) {
        return result.getCompressionEnabled() != null || result.getCompressionMimeType() != null || result.getCompressionMinSize() != null || result.getUriEncoding() != null || result.getMaxThreads() != null || result.getConnectionTimeout() != null;
    }
}

