/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.deploy.client.DeployClient;
import com.sap.core.deploy.client.IDeployer;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.cmd.commands.DeployProcessIdCommand;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import com.sap.jpaas.infrastructure.console.validator.SACValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

@Parameters(commandDescription="Provides the status of an application")
public class GetStatusCommand
extends DeployProcessIdCommand {
    private static final String STATUS_LABEL = "Status";
    public static final int EXIT_CODE_STATUS_FAILED = 52;
    @Parameter(names={"-c", "-component", "--component"}, description="Component", validateWith=SACValidator.class, hidden=true)
    String component;
    @Parameter(names={"--show-full-process-id"}, description="Shows the full ID of processes (40 characters). Takes no value. (optional)")
    boolean showFullProcessId;

    @Override
    public void run() throws CommandException {
        if (this.applicationProcessId == null) {
            if (!CheckHelper.checkArgsSpecifiedAccountApplication(this.account, this.application)) {
                throw new HelpException("Invalid parameters", 114);
            }
            this.dumpParameters();
            this.askForPasswordAndInitHttpClient();
            this.getStatusWithSAC();
        } else {
            this.dumpParameters();
            this.askForPasswordAndInitHttpClient();
            this.getStatusWithProcessID();
        }
    }

    private void getStatusWithSAC() {
        Map<String, StatusResult> statusResults = this.populateResultsMap();
        StatusResult applicationState = this.extractApplicationStateFromMap(statusResults);
        this.dumpResult(statusResults, applicationState);
        this.handleNotFoundStatusWithSAC(applicationState);
        if (!CheckHelper.isResultOK(applicationState) && !CheckHelper.isResultForbidden(applicationState)) {
            throw new CommandException(133);
        }
    }

    public void handleNotFoundStatusWithSAC(StatusResult sampleStatusResult) {
        if (Status.NOT_FOUND.equals((Object)sampleStatusResult.getStatus())) {
            StringBuilder msg = new StringBuilder("Application [" + this.application + "]");
            if (this.component != null) {
                msg.append(", component [").append(this.component).append("]");
            }
            msg.append(" not found");
            throw new CommandException(msg.toString(), 141);
        }
    }

    public StatusResult extractApplicationStateFromMap(Map<String, StatusResult> statusResults) {
        if (this.component == null) {
            StatusResult sampleStatusResult = statusResults.remove("_application_state");
            return sampleStatusResult != null ? sampleStatusResult : new StatusResult(0, Status.NOT_FOUND, null);
        }
        return statusResults.get(this.component);
    }

    public Map<String, StatusResult> populateResultsMap() {
        Map<String, StatusResult> statusResults = null;
        IDeployer deployer = this.getIDeployer();
        try {
            if (this.component == null) {
                statusResults = this.getComponentsStatuses(deployer);
            } else {
                statusResults = new TreeMap<String, StatusResult>();
                statusResults.put(this.component, deployer.getStatus(this.application, this.component, "0.0.0", this.host));
            }
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CommandException("Status check failed", e, 113);
        }
        return statusResults;
    }

    public void dumpResult(Map<String, StatusResult> statusResults, StatusResult applicationState) {
        if (this.component == null) {
            if (this.isWebOnlyComponent(statusResults)) {
                DeployDumpHelper.printStatusResult(statusResults.get("web"), STATUS_LABEL, this.showFullProcessId);
            } else {
                DeployDumpHelper.printStatusResult(applicationState, null, this.showFullProcessId);
                this.dumpComponentStatuses(statusResults);
            }
        } else {
            DeployDumpHelper.printStatusResult(statusResults.get(this.component), STATUS_LABEL, this.showFullProcessId);
        }
    }

    private boolean isWebOnlyComponent(Map<String, StatusResult> statusResults) {
        return statusResults.containsKey("web") && statusResults.size() == 1;
    }

    private void getStatusWithProcessID() {
        CheckHelper.validateApplicationProcessId(this.applicationProcessId);
        StatusResult statusResult = this.getStatusResultWithProcessId();
        DeployDumpHelper.printStatusResultFromProcess(statusResult, this.showFullProcessId);
        if (Status.NOT_FOUND.equals((Object)statusResult.getStatus())) {
            throw new CommandException(DeployDumpHelper.getMessageDetails(statusResult), 51);
        }
        if (!CheckHelper.isResultOK(statusResult) && !CheckHelper.isResultForbidden(statusResult)) {
            throw new CommandException(133);
        }
    }

    public StatusResult getStatusResultWithProcessId() {
        StatusResult statusResult;
        IDeployer deployer = this.getIDeployer();
        try {
            statusResult = deployer.getStatus(this.applicationProcessId, this.host);
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CommandException("Status check failed", 52);
        }
        return statusResult;
    }

    protected IDeployer getIDeployer() {
        IDeployer deployer = null;
        deployer = this.account != null ? DeployClient.getDeployInterface(this.account, this.httpClient, null, "CMD Tools", null) : DeployClient.getDeployInterface(this.httpClient);
        return deployer;
    }

    private void dumpParameters() {
        ArrayList argsList = new ArrayList();
        if (this.applicationProcessId != null) {
            Collections.addAll(argsList, "application process ID", this.applicationProcessId);
        }
        if (this.component != null && !this.component.equalsIgnoreCase("web")) {
            Collections.addAll(argsList, "component", this.component);
        }
        Collections.addAll(argsList, "application", this.application, "subaccount", this.account, "host", this.host);
        DumpHelper.dumpOperationList(this.user, "Requesting status for:", argsList.toArray());
    }

    private Map<String, StatusResult> getComponentsStatuses(IDeployer deployer) throws Exception {
        return deployer.listAppComponentDetails(this.application, this.host);
    }

    private void dumpComponentStatuses(Map<String, StatusResult> statusResults) {
        if (statusResults == null || statusResults.isEmpty()) {
            return;
        }
        int maxLength = 0;
        for (String cmp : statusResults.keySet()) {
            if (cmp.length() <= maxLength) continue;
            maxLength = cmp.length();
        }
        for (String cmp : statusResults.keySet()) {
            DeployDumpHelper.printStatusResult(statusResults.get(cmp), cmp, maxLength + 3, this.showFullProcessId);
        }
    }

    @Override
    public String getName() {
        return "status";
    }
}

