/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.deploy.client.cmd.commands.DeployApplicationCommand;
import com.sap.core.deploy.client.cmd.helpers.HotUpdateHelper;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.jpaas.infrastructure.console.converter.URLParameterConverter;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import com.sap.jpaas.infrastructure.console.validator.SACValidator;
import java.util.ArrayList;
import java.util.Collections;

@Parameters(commandDescription="Redeploys and updates the binaries of an application started on one process\nCaution: NOT recommended for productive applications")
public class HotUpdateCommand
extends DeployApplicationCommand {
    @Parameter(names={"-c", "-component", "--component"}, description="Component", validateWith=SACValidator.class, hidden=true)
    String component = "web";
    @Parameter(names={"-s", "-source", "--source"}, description="A comma-separated list of file locations, pointing to WAR files, or folders containing them", converter=URLParameterConverter.class)
    String source;
    @Parameter(names={"--strategy"}, description="Defines how the update will be performed. Acceptable values: replace-binaries, restart-runtime, reprovision-runtime (clean up the file system)")
    String strategy;
    @Parameter(names={"-y", "-sync", "--synchronous"}, description="Wait for the operation to complete")
    boolean synchronous;
    @Parameter(names={"--connections"}, description="Number of connections used to deploy the content: 1 to 6; default = 2")
    String uploadConnections;
    @Parameter(names={"-ds", "--delta"}, description="Deploys only the changes between the provided source and the deployed content. New content will be added; missing content will be deleted. Recommended for development use to speed up the deployment.")
    boolean delta;

    @Override
    public void run() throws CommandException {
        this.dumpParameters();
        if (!CheckHelper.checkArgSpecified("-s", "--source", this.source, true)) {
            throw new HelpException("Missing required parameter: --source", 130);
        }
        if (!CheckHelper.checkArgSpecified(null, "--connections", this.strategy, true)) {
            throw new HelpException("Missing required parameter: --strategy", 130);
        }
        HotUpdateHelper helper = new HotUpdateHelper(this.account, this);
        helper.hotUpdate(this.application, this.component, this.source, this.strategy, this.synchronous, this.uploadConnections, this.delta);
    }

    private void dumpParameters() {
        ArrayList argsList = new ArrayList();
        if (!this.component.equalsIgnoreCase("web")) {
            Collections.addAll(argsList, "component", this.component);
        }
        Collections.addAll(argsList, "application", this.application, "subaccount", this.account, "source", this.source);
        Collections.addAll(argsList, "strategy", this.strategy, "synchronous", this.synchronous, "host", this.host, "connections", this.uploadConnections);
        DumpHelper.dumpOperationList(this.user, "Requesting hot-update for:", argsList.toArray());
    }

    @Override
    public String getName() {
        return "hot-update";
    }
}

