/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.commands;

import com.beust.jcommander.Parameters;
import com.sap.core.deploy.client.RepositoryResult;
import com.sap.core.deploy.client.cmd.commands.DeployRemoteCommand;
import com.sap.core.deploy.client.cmd.helpers.ListEntityHelper;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;

@Parameters(commandDescription="Lists applications")
public class ListApplicationsCommand
extends DeployRemoteCommand {
    @Override
    public void run() throws CommandException {
        if (CheckHelper.checkArgsListAppliances(this.account, this.host)) {
            DumpHelper.dumpOperationList(this.user, "Requesting list of applications for:", "subaccount", this.account, "host", this.host);
            ListEntityHelper listEntityHelper = new ListEntityHelper(this.account, this);
            RepositoryResult repositoryResult = listEntityHelper.getApplications();
            System.out.println();
            DeployDumpHelper.printRepoResult("List of applications", repositoryResult);
            if (!CheckHelper.isResultOK(repositoryResult)) {
                throw new CommandException(138);
            }
        } else {
            throw new HelpException("Invalid parameters", 116);
        }
    }

    @Override
    public String getName() {
        return "list-applications";
    }
}

