/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.commands;

import com.beust.jcommander.Parameters;
import com.sap.core.deploy.client.RepositoryResult;
import com.sap.core.deploy.client.cmd.commands.DeployApplicationCommand;
import com.sap.core.deploy.client.cmd.helpers.ListEntityHelper;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.model.Hidden;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;

@Parameters(commandDescription="Lists components")
@Hidden
public class ListComponentsCommand
extends DeployApplicationCommand {
    @Override
    public void run() throws CommandException {
        if (CheckHelper.checkArgsListComponents(this.account, this.application, this.host)) {
            DumpHelper.dumpOperationList(this.user, "Requesting list of components for:", "application", this.application, "subaccount", this.account, "host", this.host);
            ListEntityHelper listEntityHelper = new ListEntityHelper(this.account, this);
            RepositoryResult repositoryResult = listEntityHelper.getComponents(this.application);
            System.out.println();
            DeployDumpHelper.printRepoResult("List of components", repositoryResult);
            if (!CheckHelper.isResultOK(repositoryResult)) {
                throw new CommandException(139);
            }
        } else {
            throw new HelpException("Invalid parameters", 118);
        }
    }

    @Override
    public String getName() {
        return "list-components";
    }
}

