/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.deploy.client.DeployClient;
import com.sap.core.deploy.client.IConfigurationManager;
import com.sap.core.deploy.client.cmd.commands.DeployConsoleCommand;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.core.deploy.client.exceptions.DeployClientException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.List;

@Parameters(commandDescription="Lists supported runtimes")
public class ListRuntimeTypesCommand
extends DeployConsoleCommand {
    @Parameter(names={"-a", "-account", "--account"}, description="Name of the subaccount for which you provide user and password")
    String account;

    @Override
    public void run() throws CommandException {
        List<String> runtimes;
        DumpHelper.dumpOperationList(this.user, "Requesting list of supported runtimes for:", "host", this.host);
        this.askForPasswordAndInitHttpClient();
        IConfigurationManager configManager = DeployClient.getConfigurationManager(this.httpClient, this.account);
        try {
            runtimes = configManager.listRuntimeTypes(this.host);
        }
        catch (DeployClientException e) {
            throw new CommandException("Supported runtimes listing failed", e, 144);
        }
        DeployDumpHelper.printRuntimeTypesResult("Supported runtimes:", runtimes);
    }

    @Override
    public String getName() {
        return "list-runtimes";
    }
}

