/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.deploy.client.cmd.commands.DeployConsoleCommand;
import com.sap.core.deploy.client.cmd.util.RuntimeVersionsDumpHelper;
import com.sap.core.deploy.client.cmd.util.RuntimeVersionsHelper;
import com.sap.core.deploy.client.cmd.validators.RuntimeIdValidator;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;

@Parameters(commandDescription="View the application runtime versions applications can use in SAP Cloud Platform. Only recommended versions are shown by default")
public class ListRuntimeVersionsCommand
extends DeployConsoleCommand {
    @Parameter(names={"--runtime"}, description="Name of SAP Cloud Platform application runtime", validateWith=RuntimeIdValidator.class)
    String runtimeId;
    @Parameter(names={"--all"}, description="List all supported application runtime versions. Warning: Pinning applications to a previously released application runtime version is not recommended")
    boolean allVersions;
    @Parameter(names={"-a", "-account", "--account"}, description="Name of the subaccount for which you provide user and password")
    String account;

    @Override
    public void run() throws CommandException {
        DumpHelper.dumpOperationList(this.user, "Requesting list of runtime versions for:", "host", this.host);
        this.askForPasswordAndInitHttpClient();
        RuntimeVersionsHelper runtimeVersionsHelper = new RuntimeVersionsHelper(this.httpClient, this.host, this.runtimeId, this.allVersions, this.account);
        String operationName = "Supported application runtime versions";
        RuntimeVersionsDumpHelper.printRuntimeVersionsResult(operationName, runtimeVersionsHelper, this.allVersions);
    }

    @Override
    public String getName() {
        return "list-runtime-versions";
    }
}

