/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.deploy.client.cmd.commands.StopCommand;
import com.sap.core.deploy.client.cmd.helpers.ListEntityHelper;
import com.sap.core.deploy.client.cmd.helpers.StartStopHelper;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.Set;

@Parameters(commandDescription="Restarts an application")
public class RestartCommand
extends StopCommand {
    @Parameter(names={"--disabled"}, description="Starts an application process in disabled state, so that it is not available for new connections")
    boolean startDisabled;

    @Override
    public void run() throws CommandException {
        CheckHelper.validateApplicationAndComponentArguments(this.regExp, this.application, this.component);
        StartStopHelper startStopHelper = this.createStartStopHelper(this.account);
        if (this.regExp) {
            startStopHelper.dumpParameters("mass restart", null, this.application, this.component, null, this.synchronous, this.startDisabled);
            ListEntityHelper listEntityHelper = this.createListEntityHelper(this.account);
            Set<String> matchingApplications = listEntityHelper.getApplications(this.application);
            for (String applicationName : matchingApplications) {
                if (this.component.equals("web")) {
                    startStopHelper.restart(this.applicationProcessId, applicationName, this.component, this.tenant, this.synchronous, this.statusCheck, this.ignoreFailure, this.startDisabled);
                    continue;
                }
                Set<String> matchingComponents = listEntityHelper.getComponents(applicationName, this.component);
                for (String matchingComponent : matchingComponents) {
                    startStopHelper.restart(this.applicationProcessId, applicationName, matchingComponent, this.tenant, this.synchronous, this.statusCheck, this.ignoreFailure, this.startDisabled);
                }
            }
        } else {
            startStopHelper.restart(this.applicationProcessId, this.application, this.component, this.tenant, this.synchronous, this.statusCheck, this.ignoreFailure, this.startDisabled);
        }
    }

    @Override
    public String getName() {
        return "restart";
    }

    StartStopHelper createStartStopHelper(String account) {
        return new StartStopHelper(account, this);
    }

    ListEntityHelper createListEntityHelper(String account) {
        return new ListEntityHelper(account, this);
    }
}

