/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.deploy.client.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.deploy.client.ComponentAttributesResult;
import com.sap.core.deploy.client.DeployClient;
import com.sap.core.deploy.client.IConfigurationManager;
import com.sap.core.deploy.client.IDeployer;
import com.sap.core.deploy.client.IRestartStrategy;
import com.sap.core.deploy.client.LifecycleResult;
import com.sap.core.deploy.client.Status;
import com.sap.core.deploy.client.StatusResult;
import com.sap.core.deploy.client.cmd.Constants;
import com.sap.core.deploy.client.cmd.commands.AbstractCommonDeployParametersHolder;
import com.sap.core.deploy.client.cmd.helpers.DeployHelper;
import com.sap.core.deploy.client.cmd.util.CheckHelper;
import com.sap.core.deploy.client.cmd.util.DeployDumpHelper;
import com.sap.core.deploy.client.cmd.util.RollingUpdateProgressListener;
import com.sap.core.deploy.client.cmd.util.StopExtraProcessesUtil;
import com.sap.core.deploy.client.impl.OneByOneRestartStrategy;
import com.sap.core.deploy.commons.ApplicationProcessResource;
import com.sap.core.deploy.commons.retry.RetryPerformer;
import com.sap.jpaas.infrastructure.console.exception.BackendException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.FrontendException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.help.ordering.Group;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

@Parameters(commandDescription="Perform a rolling update of an application")
public class RollingUpdateCommand
extends AbstractCommonDeployParametersHolder {
    @Parameter(names={"-t", "-tenant", "--tenant"}, description="Tenant-isolated application process for the given tenant", hidden=true)
    String tenant;
    @Group(group="command-specific parameters")
    @Parameter(names={"--timeout"}, description="Timeout in seconds before stopping the old application processes, default is 60 seconds (optional)")
    int timeout = 60;
    private final int newMinVMCount = 1;
    private static final Logger LOGGER = Logger.getLogger(RollingUpdateCommand.class);
    public static final int EXIT_CODE_APPLICATION_NOT_STARTED = 166;
    public static final int EXIT_CODE_APPLICATION_NOT_FOUND = 167;
    public static final String MESSAGE_APPLICATION_NOT_STARTED = "Application [%s] is not started. Rolling update can only be performed on running applications.";
    public static final String MESSAGE_APPLICATION_NOT_FOUND = "Application [%s] not found. Rolling update can only be performed on running applications.";

    @Override
    public String getName() {
        return "rolling-update";
    }

    @Override
    public void run() throws CommandException {
        if (!CheckHelper.checkArgsListComponents(this.account, this.application, this.host)) {
            throw new HelpException("Invalid parameters", 10);
        }
        if (!CheckHelper.checkArgSpecified("-s", "--source", this.source, true)) {
            throw new HelpException("Source not specified", 10);
        }
        this.askForPasswordAndInitHttpClient();
        this.dumpParameters("Requesting rolling update for:");
        Map<String, String> metadata = this.getValidatedAndConvertedEnvVariablesToMetadataMap();
        DeployHelper deployHelper = this.getDeployHelper();
        IDeployer deployer = this.getDeployer();
        StatusResult statusResult = this.getApplicationStatus(deployer);
        if (statusResult.getCode() != 0) {
            switch (statusResult.getStatus()) {
                case NOT_FOUND: {
                    throw new FrontendException(String.format(MESSAGE_APPLICATION_NOT_FOUND, this.application), 167);
                }
            }
            throw new BackendException(statusResult.getMessage());
        }
        if (statusResult.getStatus() != Status.STARTED) {
            throw new FrontendException(String.format(MESSAGE_APPLICATION_NOT_STARTED, this.application), 166);
        }
        IConfigurationManager configurationManager = this.getConfigurationManager();
        ComponentAttributesResult configuration = configurationManager.getConfiguration(this.application, this.component, this.host);
        Integer maxVmCount = configuration.getMaxVmCount();
        Integer minVmCount = configuration.getMinVmCount();
        this.logInfo("Returned elasticity data from configuration manager - minVmCount: %d, maxVmCount: %d", minVmCount, maxVmCount);
        int originalMaxVmCount = 1;
        int originalMinVmCount = 1;
        int newMaxVMCount = 1;
        boolean redeployNeeded = false;
        if (minVmCount != null && (originalMinVmCount = minVmCount.intValue()) != 1) {
            redeployNeeded = true;
        }
        if (maxVmCount != null) {
            originalMaxVmCount = maxVmCount;
        }
        this.logInfo("Original elasticity data parameters to be used during rolling update: originalMinVmCount = %d, originalMaxVmCount = %d", originalMinVmCount, originalMaxVmCount);
        ApplicationProcessResource[] applicationProcesses = statusResult.getApplicationProcesses();
        int desiredFinalProcessesCount = applicationProcesses.length;
        if (applicationProcesses.length < originalMaxVmCount) {
            newMaxVMCount = originalMaxVmCount;
        } else {
            newMaxVMCount = applicationProcesses.length + 1;
            redeployNeeded = true;
            desiredFinalProcessesCount = originalMaxVmCount;
        }
        this.logInfo("Update parameters to be used during rolling update: newMinVMCount = %d, newMaxVMCount = %d, redeployNeeded = %b", 1, newMaxVMCount, redeployNeeded);
        IRestartStrategy.RestartStrategy defaultRestartStrategy = deployer.getDefaultRestartStrategy();
        DeployDumpHelper.dumpWithNewLine("Following steps will be executed:");
        DeployDumpHelper.dumpWithNewLine(defaultRestartStrategy.getExecutionDescription());
        deployHelper.deploy(this.application, this.component, this.source, this.installableUnits, this.iuVersion, 1, newMaxVMCount, this.shortUrl, this.appDomains, this.services, this.mirror, this.severity, this.configFolder, this.vmArguments, this.jvmVersion, this.serviceInstancesCfg, this.vmSize, this.runtimeId, this.runtimeVersion, this.uploadConnections, this.compression, this.compressibleMimeTypes, this.compressionMinSize, this.permStorageMode, this.permStorageSize, this.permStorageLocalPath, this.uriEncoding, this.maxThreads, this.connectionTimeout, Constants.PARAM_DEPLOY_TIMEOUT_DEFAULT_VALUE, false, metadata);
        try {
            LifecycleResult lifecycleResult = this.restartApplication(deployer);
            DeployDumpHelper.printAndCheckLifecycleResult("Rolling update", lifecycleResult, 210, false);
        }
        catch (CommandException ce) {
            LOGGER.error("CommandException was thrown when executing a step from the rolling update.", ce);
            throw new BackendException("Rolling update failed. Re-execute the rolling-update command.", 210);
        }
        finally {
            this.performPostDeploy(metadata, deployHelper, originalMaxVmCount, originalMinVmCount, redeployNeeded);
            new StopExtraProcessesUtil(this.application, this.component, this.host, this.tenant).stopExtraProcesses(deployer, desiredFinalProcessesCount);
        }
        StatusResult statusAfterRestart = this.getApplicationStatus(deployer);
        DeployDumpHelper.printStatusResult(statusAfterRestart, this.component);
    }

    protected void performPostDeploy(Map<String, String> metadata, DeployHelper deployer, int originalMaxVmCount, int originalMinVmCount, boolean redeployNeeded) {
        if (redeployNeeded) {
            DeployDumpHelper.dumpWithDateNewLine("Restoring the application elasticity to the original values");
            LOGGER.info(String.format("Restoring the application elasticity to the original values: min %d; max: %d", originalMinVmCount, originalMaxVmCount));
            Set<String> networkIssuesExceptionMessages = OneByOneRestartStrategy.NETWORK_ISSUES_EXCEPTION_MESSAGES;
            networkIssuesExceptionMessages.add(CommandException.class.getName());
            RetryPerformer retryPerformer = new RetryPerformer(15, 30000, false, networkIssuesExceptionMessages);
            try {
                retryPerformer.retry(deployer, "deploy", new Object[]{this.application, this.component, this.source, this.installableUnits, this.iuVersion, originalMinVmCount, originalMaxVmCount, this.shortUrl, this.appDomains, this.services, this.mirror, this.severity, this.configFolder, this.vmArguments, this.jvmVersion, this.serviceInstancesCfg, this.vmSize, this.runtimeId, this.runtimeVersion, this.uploadConnections, this.compression, this.compressibleMimeTypes, this.compressionMinSize, this.permStorageMode, this.permStorageSize, this.permStorageLocalPath, this.uriEncoding, this.maxThreads, this.connectionTimeout, Constants.PARAM_DEPLOY_TIMEOUT_DEFAULT_VALUE, false, metadata});
            }
            catch (Exception e) {
                LOGGER.error("RetryPerformer failed with exception", e);
            }
        }
    }

    protected IConfigurationManager getConfigurationManager() {
        return DeployClient.getConfigurationManager(this.httpClient, this.account, "CMD Tools", null);
    }

    protected IDeployer getDeployer() {
        return DeployClient.getDeployInterface(this.account, this.httpClient, null, "CMD Tools", null);
    }

    private StatusResult getApplicationStatus(IDeployer deployer) {
        StatusResult statusResult;
        try {
            statusResult = deployer.getStatus(this.application, this.component, "0.0.0", this.host);
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new BackendException("Status check failed", e);
        }
        return statusResult;
    }

    private LifecycleResult restartApplication(IDeployer deployer) {
        LifecycleResult result;
        try {
            result = deployer.restart(this.application, this.component, "0.0.0", this.host, this.tenant, this.timeout, new RollingUpdateProgressListener());
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new BackendException("Restart failed", e);
        }
        return result;
    }

    protected DeployHelper getDeployHelper() {
        return new DeployHelper(this.account, this);
    }

    @Override
    protected List<Object> addSpecificArguments(List<Object> argsList) {
        if (null != this.tenant) {
            Collections.addAll(argsList, "tenant", this.tenant);
        }
        DeployDumpHelper.addEnvVariablesToArgsList(argsList, this.environmentVariables);
        Collections.addAll(argsList, "timeout", this.timeout);
        return argsList;
    }

    @Override
    protected String getRuntimeId() {
        return this.runtimeId;
    }

    @Override
    protected String getSeverity() {
        return this.severity;
    }

    @Override
    protected String getInstallableUnits() {
        return this.installableUnits;
    }

    private void logInfo(String template, Object ... args) {
        String message = String.format(template, args);
        LOGGER.info(message);
    }
}

